// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A complex object that can be used to specify alternative spellings or synonyms to the root entity name.
 */
@Fluent
public final class CustomEntityAlias implements JsonSerializable<CustomEntityAlias> {
    /*
     * The text of the alias.
     */
    private final String text;

    /*
     * Determine if the alias is case sensitive.
     */
    private Boolean caseSensitive;

    /*
     * Determine if the alias is accent sensitive.
     */
    private Boolean accentSensitive;

    /*
     * Determine the fuzzy edit distance of the alias.
     */
    private Integer fuzzyEditDistance;

    /**
     * Creates an instance of CustomEntityAlias class.
     * 
     * @param text the text value to set.
     */
    public CustomEntityAlias(String text) {
        this.text = text;
    }

    /**
     * Get the text property: The text of the alias.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Get the caseSensitive property: Determine if the alias is case sensitive.
     * 
     * @return the caseSensitive value.
     */
    public Boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /**
     * Set the caseSensitive property: Determine if the alias is case sensitive.
     * 
     * @param caseSensitive the caseSensitive value to set.
     * @return the CustomEntityAlias object itself.
     */
    public CustomEntityAlias setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    /**
     * Get the accentSensitive property: Determine if the alias is accent sensitive.
     * 
     * @return the accentSensitive value.
     */
    public Boolean isAccentSensitive() {
        return this.accentSensitive;
    }

    /**
     * Set the accentSensitive property: Determine if the alias is accent sensitive.
     * 
     * @param accentSensitive the accentSensitive value to set.
     * @return the CustomEntityAlias object itself.
     */
    public CustomEntityAlias setAccentSensitive(Boolean accentSensitive) {
        this.accentSensitive = accentSensitive;
        return this;
    }

    /**
     * Get the fuzzyEditDistance property: Determine the fuzzy edit distance of the alias.
     * 
     * @return the fuzzyEditDistance value.
     */
    public Integer getFuzzyEditDistance() {
        return this.fuzzyEditDistance;
    }

    /**
     * Set the fuzzyEditDistance property: Determine the fuzzy edit distance of the alias.
     * 
     * @param fuzzyEditDistance the fuzzyEditDistance value to set.
     * @return the CustomEntityAlias object itself.
     */
    public CustomEntityAlias setFuzzyEditDistance(Integer fuzzyEditDistance) {
        this.fuzzyEditDistance = fuzzyEditDistance;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeBooleanField("caseSensitive", this.caseSensitive);
        jsonWriter.writeBooleanField("accentSensitive", this.accentSensitive);
        jsonWriter.writeNumberField("fuzzyEditDistance", this.fuzzyEditDistance);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomEntityAlias from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomEntityAlias if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomEntityAlias.
     */
    public static CustomEntityAlias fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            Boolean caseSensitive = null;
            Boolean accentSensitive = null;
            Integer fuzzyEditDistance = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                } else if ("caseSensitive".equals(fieldName)) {
                    caseSensitive = reader.getNullable(JsonReader::getBoolean);
                } else if ("accentSensitive".equals(fieldName)) {
                    accentSensitive = reader.getNullable(JsonReader::getBoolean);
                } else if ("fuzzyEditDistance".equals(fieldName)) {
                    fuzzyEditDistance = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (textFound) {
                CustomEntityAlias deserializedCustomEntityAlias = new CustomEntityAlias(text);
                deserializedCustomEntityAlias.caseSensitive = caseSensitive;
                deserializedCustomEntityAlias.accentSensitive = accentSensitive;
                deserializedCustomEntityAlias.fuzzyEditDistance = fuzzyEditDistance;

                return deserializedCustomEntityAlias;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}
