// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A token filter that only keeps tokens with text contained in a specified list of words. This token filter is
 * implemented using Apache Lucene.
 */
@Fluent
public final class KeepTokenFilter extends TokenFilter {

    /*
     * A URI fragment specifying the type of token filter.
     */
    private String odataType = "#Microsoft.Azure.Search.KeepTokenFilter";

    /*
     * The list of words to keep.
     */
    private final List<String> keepWords;

    /*
     * A value indicating whether to lower case all words first. Default is false.
     */
    private Boolean lowerCaseKeepWords;

    /**
     * Creates an instance of KeepTokenFilter class.
     *
     * @param name the name value to set.
     * @param keepWords the keepWords value to set.
     */
    public KeepTokenFilter(String name, List<String> keepWords) {
        super(name);
        this.keepWords = keepWords;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     *
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the keepWords property: The list of words to keep.
     *
     * @return the keepWords value.
     */
    public List<String> getKeepWords() {
        return this.keepWords;
    }

    /**
     * Get the lowerCaseKeepWords property: A value indicating whether to lower case all words first. Default is false.
     *
     * @return the lowerCaseKeepWords value.
     */
    public Boolean areLowerCaseKeepWords() {
        return this.lowerCaseKeepWords;
    }

    /**
     * Set the lowerCaseKeepWords property: A value indicating whether to lower case all words first. Default is false.
     *
     * @param lowerCaseKeepWords the lowerCaseKeepWords value to set.
     * @return the KeepTokenFilter object itself.
     */
    public KeepTokenFilter setLowerCaseKeepWords(Boolean lowerCaseKeepWords) {
        this.lowerCaseKeepWords = lowerCaseKeepWords;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeArrayField("keepWords", this.keepWords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("keepWordsCase", this.lowerCaseKeepWords);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeepTokenFilter from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeepTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeepTokenFilter.
     */
    public static KeepTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean keepWordsFound = false;
            List<String> keepWords = null;
            String odataType = "#Microsoft.Azure.Search.KeepTokenFilter";
            Boolean lowerCaseKeepWords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("keepWords".equals(fieldName)) {
                    keepWords = reader.readArray(reader1 -> reader1.getString());
                    keepWordsFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("keepWordsCase".equals(fieldName)) {
                    lowerCaseKeepWords = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && keepWordsFound) {
                KeepTokenFilter deserializedKeepTokenFilter = new KeepTokenFilter(name, keepWords);
                deserializedKeepTokenFilter.odataType = odataType;
                deserializedKeepTokenFilter.lowerCaseKeepWords = lowerCaseKeepWords;
                return deserializedKeepTokenFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!keepWordsFound) {
                missingProperties.add("keepWords");
            }
            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
