// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The language codes supported for input by OcrSkill.
 */
public final class OcrSkillLanguage extends ExpandableStringEnum<OcrSkillLanguage> {
    /**
     * Afrikaans.
     */
    public static final OcrSkillLanguage AF = fromString("af");

    /**
     * Albanian.
     */
    public static final OcrSkillLanguage SQ = fromString("sq");

    /**
     * Angika (Devanagiri).
     */
    public static final OcrSkillLanguage ANP = fromString("anp");

    /**
     * Arabic.
     */
    public static final OcrSkillLanguage AR = fromString("ar");

    /**
     * Asturian.
     */
    public static final OcrSkillLanguage AST = fromString("ast");

    /**
     * Awadhi-Hindi (Devanagiri).
     */
    public static final OcrSkillLanguage AWA = fromString("awa");

    /**
     * Azerbaijani (Latin).
     */
    public static final OcrSkillLanguage AZ = fromString("az");

    /**
     * Bagheli.
     */
    public static final OcrSkillLanguage BFY = fromString("bfy");

    /**
     * Basque.
     */
    public static final OcrSkillLanguage EU = fromString("eu");

    /**
     * Belarusian (Cyrillic and Latin).
     */
    public static final OcrSkillLanguage BE = fromString("be");

    /**
     * Belarusian (Cyrillic).
     */
    public static final OcrSkillLanguage BE_CYRL = fromString("be-cyrl");

    /**
     * Belarusian (Latin).
     */
    public static final OcrSkillLanguage BE_LATN = fromString("be-latn");

    /**
     * Bhojpuri-Hindi (Devanagiri).
     */
    public static final OcrSkillLanguage BHO = fromString("bho");

    /**
     * Bislama.
     */
    public static final OcrSkillLanguage BI = fromString("bi");

    /**
     * Bodo (Devanagiri).
     */
    public static final OcrSkillLanguage BRX = fromString("brx");

    /**
     * Bosnian Latin.
     */
    public static final OcrSkillLanguage BS = fromString("bs");

    /**
     * Brajbha.
     */
    public static final OcrSkillLanguage BRA = fromString("bra");

    /**
     * Breton.
     */
    public static final OcrSkillLanguage BR = fromString("br");

    /**
     * Bulgarian.
     */
    public static final OcrSkillLanguage BG = fromString("bg");

    /**
     * Bundeli.
     */
    public static final OcrSkillLanguage BNS = fromString("bns");

    /**
     * Buryat (Cyrillic).
     */
    public static final OcrSkillLanguage BUA = fromString("bua");

    /**
     * Catalan.
     */
    public static final OcrSkillLanguage CA = fromString("ca");

    /**
     * Cebuano.
     */
    public static final OcrSkillLanguage CEB = fromString("ceb");

    /**
     * Chamling.
     */
    public static final OcrSkillLanguage RAB = fromString("rab");

    /**
     * Chamorro.
     */
    public static final OcrSkillLanguage CH = fromString("ch");

    /**
     * Chhattisgarhi (Devanagiri).
     */
    public static final OcrSkillLanguage HNE = fromString("hne");

    /**
     * Chinese Simplified.
     */
    public static final OcrSkillLanguage ZH_HANS = fromString("zh-Hans");

    /**
     * Chinese Traditional.
     */
    public static final OcrSkillLanguage ZH_HANT = fromString("zh-Hant");

    /**
     * Cornish.
     */
    public static final OcrSkillLanguage KW = fromString("kw");

    /**
     * Corsican.
     */
    public static final OcrSkillLanguage CO = fromString("co");

    /**
     * Crimean Tatar (Latin).
     */
    public static final OcrSkillLanguage CRH = fromString("crh");

    /**
     * Croatian.
     */
    public static final OcrSkillLanguage HR = fromString("hr");

    /**
     * Czech.
     */
    public static final OcrSkillLanguage CS = fromString("cs");

    /**
     * Danish.
     */
    public static final OcrSkillLanguage DA = fromString("da");

    /**
     * Dari.
     */
    public static final OcrSkillLanguage PRS = fromString("prs");

    /**
     * Dhimal (Devanagiri).
     */
    public static final OcrSkillLanguage DHI = fromString("dhi");

    /**
     * Dogri (Devanagiri).
     */
    public static final OcrSkillLanguage DOI = fromString("doi");

    /**
     * Dutch.
     */
    public static final OcrSkillLanguage NL = fromString("nl");

    /**
     * English.
     */
    public static final OcrSkillLanguage EN = fromString("en");

    /**
     * Erzya (Cyrillic).
     */
    public static final OcrSkillLanguage MYV = fromString("myv");

    /**
     * Estonian.
     */
    public static final OcrSkillLanguage ET = fromString("et");

    /**
     * Faroese.
     */
    public static final OcrSkillLanguage FO = fromString("fo");

    /**
     * Fijian.
     */
    public static final OcrSkillLanguage FJ = fromString("fj");

    /**
     * Filipino.
     */
    public static final OcrSkillLanguage FIL = fromString("fil");

    /**
     * Finnish.
     */
    public static final OcrSkillLanguage FI = fromString("fi");

    /**
     * French.
     */
    public static final OcrSkillLanguage FR = fromString("fr");

    /**
     * Frulian.
     */
    public static final OcrSkillLanguage FUR = fromString("fur");

    /**
     * Gagauz (Latin).
     */
    public static final OcrSkillLanguage GAG = fromString("gag");

    /**
     * Galician.
     */
    public static final OcrSkillLanguage GL = fromString("gl");

    /**
     * German.
     */
    public static final OcrSkillLanguage DE = fromString("de");

    /**
     * Gilbertese.
     */
    public static final OcrSkillLanguage GIL = fromString("gil");

    /**
     * Gondi (Devanagiri).
     */
    public static final OcrSkillLanguage GON = fromString("gon");

    /**
     * Greek.
     */
    public static final OcrSkillLanguage EL = fromString("el");

    /**
     * Greenlandic.
     */
    public static final OcrSkillLanguage KL = fromString("kl");

    /**
     * Gurung (Devanagiri).
     */
    public static final OcrSkillLanguage GVR = fromString("gvr");

    /**
     * Haitian Creole.
     */
    public static final OcrSkillLanguage HT = fromString("ht");

    /**
     * Halbi (Devanagiri).
     */
    public static final OcrSkillLanguage HLB = fromString("hlb");

    /**
     * Hani.
     */
    public static final OcrSkillLanguage HNI = fromString("hni");

    /**
     * Haryanvi.
     */
    public static final OcrSkillLanguage BGC = fromString("bgc");

    /**
     * Hawaiian.
     */
    public static final OcrSkillLanguage HAW = fromString("haw");

    /**
     * Hindi.
     */
    public static final OcrSkillLanguage HI = fromString("hi");

    /**
     * Hmong Daw (Latin).
     */
    public static final OcrSkillLanguage MWW = fromString("mww");

    /**
     * Ho (Devanagiri).
     */
    public static final OcrSkillLanguage HOC = fromString("hoc");

    /**
     * Hungarian.
     */
    public static final OcrSkillLanguage HU = fromString("hu");

    /**
     * Icelandic.
     */
    public static final OcrSkillLanguage IS = fromString("is");

    /**
     * Inari Sami.
     */
    public static final OcrSkillLanguage SMN = fromString("smn");

    /**
     * Indonesian.
     */
    public static final OcrSkillLanguage ID = fromString("id");

    /**
     * Interlingua.
     */
    public static final OcrSkillLanguage IA = fromString("ia");

    /**
     * Inuktitut (Latin).
     */
    public static final OcrSkillLanguage IU = fromString("iu");

    /**
     * Irish.
     */
    public static final OcrSkillLanguage GA = fromString("ga");

    /**
     * Italian.
     */
    public static final OcrSkillLanguage IT = fromString("it");

    /**
     * Japanese.
     */
    public static final OcrSkillLanguage JA = fromString("ja");

    /**
     * Jaunsari (Devanagiri).
     */
    public static final OcrSkillLanguage JNS = fromString("Jns");

    /**
     * Javanese.
     */
    public static final OcrSkillLanguage JV = fromString("jv");

    /**
     * Kabuverdianu.
     */
    public static final OcrSkillLanguage KEA = fromString("kea");

    /**
     * Kachin (Latin).
     */
    public static final OcrSkillLanguage KAC = fromString("kac");

    /**
     * Kangri (Devanagiri).
     */
    public static final OcrSkillLanguage XNR = fromString("xnr");

    /**
     * Karachay-Balkar.
     */
    public static final OcrSkillLanguage KRC = fromString("krc");

    /**
     * Kara-Kalpak (Cyrillic).
     */
    public static final OcrSkillLanguage KAA_CYRL = fromString("kaa-cyrl");

    /**
     * Kara-Kalpak (Latin).
     */
    public static final OcrSkillLanguage KAA = fromString("kaa");

    /**
     * Kashubian.
     */
    public static final OcrSkillLanguage CSB = fromString("csb");

    /**
     * Kazakh (Cyrillic).
     */
    public static final OcrSkillLanguage KK_CYRL = fromString("kk-cyrl");

    /**
     * Kazakh (Latin).
     */
    public static final OcrSkillLanguage KK_LATN = fromString("kk-latn");

    /**
     * Khaling.
     */
    public static final OcrSkillLanguage KLR = fromString("klr");

    /**
     * Khasi.
     */
    public static final OcrSkillLanguage KHA = fromString("kha");

    /**
     * K'iche'.
     */
    public static final OcrSkillLanguage QUC = fromString("quc");

    /**
     * Korean.
     */
    public static final OcrSkillLanguage KO = fromString("ko");

    /**
     * Korku.
     */
    public static final OcrSkillLanguage KFQ = fromString("kfq");

    /**
     * Koryak.
     */
    public static final OcrSkillLanguage KPY = fromString("kpy");

    /**
     * Kosraean.
     */
    public static final OcrSkillLanguage KOS = fromString("kos");

    /**
     * Kumyk (Cyrillic).
     */
    public static final OcrSkillLanguage KUM = fromString("kum");

    /**
     * Kurdish (Arabic).
     */
    public static final OcrSkillLanguage KU_ARAB = fromString("ku-arab");

    /**
     * Kurdish (Latin).
     */
    public static final OcrSkillLanguage KU_LATN = fromString("ku-latn");

    /**
     * Kurukh (Devanagiri).
     */
    public static final OcrSkillLanguage KRU = fromString("kru");

    /**
     * Kyrgyz (Cyrillic).
     */
    public static final OcrSkillLanguage KY = fromString("ky");

    /**
     * Lakota.
     */
    public static final OcrSkillLanguage LKT = fromString("lkt");

    /**
     * Latin.
     */
    public static final OcrSkillLanguage LA = fromString("la");

    /**
     * Lithuanian.
     */
    public static final OcrSkillLanguage LT = fromString("lt");

    /**
     * Lower Sorbian.
     */
    public static final OcrSkillLanguage DSB = fromString("dsb");

    /**
     * Lule Sami.
     */
    public static final OcrSkillLanguage SMJ = fromString("smj");

    /**
     * Luxembourgish.
     */
    public static final OcrSkillLanguage LB = fromString("lb");

    /**
     * Mahasu Pahari (Devanagiri).
     */
    public static final OcrSkillLanguage BFZ = fromString("bfz");

    /**
     * Malay (Latin).
     */
    public static final OcrSkillLanguage MS = fromString("ms");

    /**
     * Maltese.
     */
    public static final OcrSkillLanguage MT = fromString("mt");

    /**
     * Malto (Devanagiri).
     */
    public static final OcrSkillLanguage KMJ = fromString("kmj");

    /**
     * Manx.
     */
    public static final OcrSkillLanguage GV = fromString("gv");

    /**
     * Maori.
     */
    public static final OcrSkillLanguage MI = fromString("mi");

    /**
     * Marathi.
     */
    public static final OcrSkillLanguage MR = fromString("mr");

    /**
     * Mongolian (Cyrillic).
     */
    public static final OcrSkillLanguage MN = fromString("mn");

    /**
     * Montenegrin (Cyrillic).
     */
    public static final OcrSkillLanguage CNR_CYRL = fromString("cnr-cyrl");

    /**
     * Montenegrin (Latin).
     */
    public static final OcrSkillLanguage CNR_LATN = fromString("cnr-latn");

    /**
     * Neapolitan.
     */
    public static final OcrSkillLanguage NAP = fromString("nap");

    /**
     * Nepali.
     */
    public static final OcrSkillLanguage NE = fromString("ne");

    /**
     * Niuean.
     */
    public static final OcrSkillLanguage NIU = fromString("niu");

    /**
     * Nogay.
     */
    public static final OcrSkillLanguage NOG = fromString("nog");

    /**
     * Northern Sami (Latin).
     */
    public static final OcrSkillLanguage SME = fromString("sme");

    /**
     * Norwegian.
     */
    public static final OcrSkillLanguage NB = fromString("nb");

    /**
     * Norwegian.
     */
    public static final OcrSkillLanguage NO = fromString("no");

    /**
     * Occitan.
     */
    public static final OcrSkillLanguage OC = fromString("oc");

    /**
     * Ossetic.
     */
    public static final OcrSkillLanguage OS = fromString("os");

    /**
     * Pashto.
     */
    public static final OcrSkillLanguage PS = fromString("ps");

    /**
     * Persian.
     */
    public static final OcrSkillLanguage FA = fromString("fa");

    /**
     * Polish.
     */
    public static final OcrSkillLanguage PL = fromString("pl");

    /**
     * Portuguese.
     */
    public static final OcrSkillLanguage PT = fromString("pt");

    /**
     * Punjabi (Arabic).
     */
    public static final OcrSkillLanguage PA = fromString("pa");

    /**
     * Ripuarian.
     */
    public static final OcrSkillLanguage KSH = fromString("ksh");

    /**
     * Romanian.
     */
    public static final OcrSkillLanguage RO = fromString("ro");

    /**
     * Romansh.
     */
    public static final OcrSkillLanguage RM = fromString("rm");

    /**
     * Russian.
     */
    public static final OcrSkillLanguage RU = fromString("ru");

    /**
     * Sadri (Devanagiri).
     */
    public static final OcrSkillLanguage SCK = fromString("sck");

    /**
     * Samoan (Latin).
     */
    public static final OcrSkillLanguage SM = fromString("sm");

    /**
     * Sanskrit (Devanagiri).
     */
    public static final OcrSkillLanguage SA = fromString("sa");

    /**
     * Santali (Devanagiri).
     */
    public static final OcrSkillLanguage SAT = fromString("sat");

    /**
     * Scots.
     */
    public static final OcrSkillLanguage SCO = fromString("sco");

    /**
     * Scottish Gaelic.
     */
    public static final OcrSkillLanguage GD = fromString("gd");

    /**
     * Serbian (Latin).
     */
    public static final OcrSkillLanguage SR = fromString("sr");

    /**
     * Serbian (Cyrillic).
     */
    public static final OcrSkillLanguage SR_CYRL = fromString("sr-Cyrl");

    /**
     * Serbian (Latin).
     */
    public static final OcrSkillLanguage SR_LATN = fromString("sr-Latn");

    /**
     * Sherpa (Devanagiri).
     */
    public static final OcrSkillLanguage XSR = fromString("xsr");

    /**
     * Sirmauri (Devanagiri).
     */
    public static final OcrSkillLanguage SRX = fromString("srx");

    /**
     * Skolt Sami.
     */
    public static final OcrSkillLanguage SMS = fromString("sms");

    /**
     * Slovak.
     */
    public static final OcrSkillLanguage SK = fromString("sk");

    /**
     * Slovenian.
     */
    public static final OcrSkillLanguage SL = fromString("sl");

    /**
     * Somali (Arabic).
     */
    public static final OcrSkillLanguage SO = fromString("so");

    /**
     * Southern Sami.
     */
    public static final OcrSkillLanguage SMA = fromString("sma");

    /**
     * Spanish.
     */
    public static final OcrSkillLanguage ES = fromString("es");

    /**
     * Swahili (Latin).
     */
    public static final OcrSkillLanguage SW = fromString("sw");

    /**
     * Swedish.
     */
    public static final OcrSkillLanguage SV = fromString("sv");

    /**
     * Tajik (Cyrillic).
     */
    public static final OcrSkillLanguage TG = fromString("tg");

    /**
     * Tatar (Latin).
     */
    public static final OcrSkillLanguage TT = fromString("tt");

    /**
     * Tetum.
     */
    public static final OcrSkillLanguage TET = fromString("tet");

    /**
     * Thangmi.
     */
    public static final OcrSkillLanguage THF = fromString("thf");

    /**
     * Tongan.
     */
    public static final OcrSkillLanguage TO = fromString("to");

    /**
     * Turkish.
     */
    public static final OcrSkillLanguage TR = fromString("tr");

    /**
     * Turkmen (Latin).
     */
    public static final OcrSkillLanguage TK = fromString("tk");

    /**
     * Tuvan.
     */
    public static final OcrSkillLanguage TYV = fromString("tyv");

    /**
     * Upper Sorbian.
     */
    public static final OcrSkillLanguage HSB = fromString("hsb");

    /**
     * Urdu.
     */
    public static final OcrSkillLanguage UR = fromString("ur");

    /**
     * Uyghur (Arabic).
     */
    public static final OcrSkillLanguage UG = fromString("ug");

    /**
     * Uzbek (Arabic).
     */
    public static final OcrSkillLanguage UZ_ARAB = fromString("uz-arab");

    /**
     * Uzbek (Cyrillic).
     */
    public static final OcrSkillLanguage UZ_CYRL = fromString("uz-cyrl");

    /**
     * Uzbek (Latin).
     */
    public static final OcrSkillLanguage UZ = fromString("uz");

    /**
     * Volapük.
     */
    public static final OcrSkillLanguage VO = fromString("vo");

    /**
     * Walser.
     */
    public static final OcrSkillLanguage WAE = fromString("wae");

    /**
     * Welsh.
     */
    public static final OcrSkillLanguage CY = fromString("cy");

    /**
     * Western Frisian.
     */
    public static final OcrSkillLanguage FY = fromString("fy");

    /**
     * Yucatec Maya.
     */
    public static final OcrSkillLanguage YUA = fromString("yua");

    /**
     * Zhuang.
     */
    public static final OcrSkillLanguage ZA = fromString("za");

    /**
     * Zulu.
     */
    public static final OcrSkillLanguage ZU = fromString("zu");

    /**
     * Unknown (All).
     */
    public static final OcrSkillLanguage UNK = fromString("unk");

    /**
     * Creates a new instance of OcrSkillLanguage value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OcrSkillLanguage() {
    }

    /**
     * Creates or finds a OcrSkillLanguage from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OcrSkillLanguage.
     */
    public static OcrSkillLanguage fromString(String name) {
        return fromString(name, OcrSkillLanguage.class);
    }

    /**
     * Gets known OcrSkillLanguage values.
     * 
     * @return known OcrSkillLanguage values.
     */
    public static Collection<OcrSkillLanguage> values() {
        return values(OcrSkillLanguage.class);
    }
}
