// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the identity for a datasource to use.
 */
@Immutable
public final class SearchIndexerDataUserAssignedIdentity extends SearchIndexerDataIdentity {
    /*
     * A URI fragment specifying the type of identity.
     */
    private String odataType = "#Microsoft.Azure.Search.DataUserAssignedIdentity";

    /*
     * The fully qualified Azure resource Id of a user assigned managed identity typically in the form
     * "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
     * that should have been assigned to the search service.
     */
    private final String resourceId;

    /**
     * Creates an instance of SearchIndexerDataUserAssignedIdentity class.
     * 
     * @param resourceId the resourceId value to set.
     */
    public SearchIndexerDataUserAssignedIdentity(String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of identity.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the resourceId property: The fully qualified Azure resource Id of a user assigned managed identity typically
     * in the form
     * "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
     * that should have been assigned to the search service.
     * 
     * @return the resourceId value.
     */
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userAssignedIdentity", this.resourceId);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerDataUserAssignedIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerDataUserAssignedIdentity if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexerDataUserAssignedIdentity.
     */
    public static SearchIndexerDataUserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean resourceIdFound = false;
            String resourceId = null;
            String odataType = "#Microsoft.Azure.Search.DataUserAssignedIdentity";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userAssignedIdentity".equals(fieldName)) {
                    resourceId = reader.getString();
                    resourceIdFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (resourceIdFound) {
                SearchIndexerDataUserAssignedIdentity deserializedSearchIndexerDataUserAssignedIdentity
                    = new SearchIndexerDataUserAssignedIdentity(resourceId);
                deserializedSearchIndexerDataUserAssignedIdentity.odataType = odataType;

                return deserializedSearchIndexerDataUserAssignedIdentity;
            }
            throw new IllegalStateException("Missing required property: userAssignedIdentity");
        });
    }
}
