// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Projection definition for what data to store in Azure Files.
 */
@Fluent
public final class SearchIndexerKnowledgeStoreFileProjectionSelector
    extends SearchIndexerKnowledgeStoreBlobProjectionSelector {
    /**
     * Creates an instance of SearchIndexerKnowledgeStoreFileProjectionSelector class.
     * 
     * @param storageContainer the storageContainer value to set.
     */
    public SearchIndexerKnowledgeStoreFileProjectionSelector(String storageContainer) {
        super(storageContainer);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SearchIndexerKnowledgeStoreFileProjectionSelector setReferenceKeyName(String referenceKeyName) {
        super.setReferenceKeyName(referenceKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SearchIndexerKnowledgeStoreFileProjectionSelector setGeneratedKeyName(String generatedKeyName) {
        super.setGeneratedKeyName(generatedKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SearchIndexerKnowledgeStoreFileProjectionSelector setSource(String source) {
        super.setSource(source);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SearchIndexerKnowledgeStoreFileProjectionSelector setSourceContext(String sourceContext) {
        super.setSourceContext(sourceContext);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SearchIndexerKnowledgeStoreFileProjectionSelector setInputs(List<InputFieldMappingEntry> inputs) {
        super.setInputs(inputs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageContainer", getStorageContainer());
        jsonWriter.writeStringField("referenceKeyName", getReferenceKeyName());
        jsonWriter.writeStringField("generatedKeyName", getGeneratedKeyName());
        jsonWriter.writeStringField("source", getSource());
        jsonWriter.writeStringField("sourceContext", getSourceContext());
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerKnowledgeStoreFileProjectionSelector from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerKnowledgeStoreFileProjectionSelector if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexerKnowledgeStoreFileProjectionSelector.
     */
    public static SearchIndexerKnowledgeStoreFileProjectionSelector fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean storageContainerFound = false;
            String storageContainer = null;
            String referenceKeyName = null;
            String generatedKeyName = null;
            String source = null;
            String sourceContext = null;
            List<InputFieldMappingEntry> inputs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageContainer".equals(fieldName)) {
                    storageContainer = reader.getString();
                    storageContainerFound = true;
                } else if ("referenceKeyName".equals(fieldName)) {
                    referenceKeyName = reader.getString();
                } else if ("generatedKeyName".equals(fieldName)) {
                    generatedKeyName = reader.getString();
                } else if ("source".equals(fieldName)) {
                    source = reader.getString();
                } else if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                } else if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            if (storageContainerFound) {
                SearchIndexerKnowledgeStoreFileProjectionSelector deserializedSearchIndexerKnowledgeStoreFileProjectionSelector
                    = new SearchIndexerKnowledgeStoreFileProjectionSelector(storageContainer);
                deserializedSearchIndexerKnowledgeStoreFileProjectionSelector.setReferenceKeyName(referenceKeyName);
                deserializedSearchIndexerKnowledgeStoreFileProjectionSelector.setGeneratedKeyName(generatedKeyName);
                deserializedSearchIndexerKnowledgeStoreFileProjectionSelector.setSource(source);
                deserializedSearchIndexerKnowledgeStoreFileProjectionSelector.setSourceContext(sourceContext);
                deserializedSearchIndexerKnowledgeStoreFileProjectionSelector.setInputs(inputs);

                return deserializedSearchIndexerKnowledgeStoreFileProjectionSelector;
            }
            throw new IllegalStateException("Missing required property: storageContainer");
        });
    }
}
