// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Filters out tokens with same text as the previous token. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class UniqueTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    private String odataType = "#Microsoft.Azure.Search.UniqueTokenFilter";

    /*
     * A value indicating whether to remove duplicates only at the same position. Default is false.
     */
    private Boolean onlyOnSamePosition;

    /**
     * Creates an instance of UniqueTokenFilter class.
     * 
     * @param name the name value to set.
     */
    public UniqueTokenFilter(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the onlyOnSamePosition property: A value indicating whether to remove duplicates only at the same position.
     * Default is false.
     * 
     * @return the onlyOnSamePosition value.
     */
    public Boolean isOnlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    /**
     * Set the onlyOnSamePosition property: A value indicating whether to remove duplicates only at the same position.
     * Default is false.
     * 
     * @param onlyOnSamePosition the onlyOnSamePosition value to set.
     * @return the UniqueTokenFilter object itself.
     */
    public UniqueTokenFilter setOnlyOnSamePosition(Boolean onlyOnSamePosition) {
        this.onlyOnSamePosition = onlyOnSamePosition;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("onlyOnSamePosition", this.onlyOnSamePosition);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UniqueTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UniqueTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UniqueTokenFilter.
     */
    public static UniqueTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.UniqueTokenFilter";
            Boolean onlyOnSamePosition = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("onlyOnSamePosition".equals(fieldName)) {
                    onlyOnSamePosition = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                UniqueTokenFilter deserializedUniqueTokenFilter = new UniqueTokenFilter(name);
                deserializedUniqueTokenFilter.odataType = odataType;
                deserializedUniqueTokenFilter.onlyOnSamePosition = onlyOnSamePosition;

                return deserializedUniqueTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
