// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the vectorization method to be used during query time.
 */
@Immutable
public class VectorSearchVectorizer implements JsonSerializable<VectorSearchVectorizer> {
    /*
     * The name of the kind of vectorization method being configured for use with vector search.
     */
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.fromString("VectorSearchVectorizer");

    /*
     * The name to associate with this particular vectorization method.
     */
    private final String vectorizerName;

    /**
     * Creates an instance of VectorSearchVectorizer class.
     * 
     * @param vectorizerName the vectorizerName value to set.
     */
    public VectorSearchVectorizer(String vectorizerName) {
        this.vectorizerName = vectorizerName;
    }

    /**
     * Get the kind property: The name of the kind of vectorization method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    /**
     * Get the vectorizerName property: The name to associate with this particular vectorization method.
     * 
     * @return the vectorizerName value.
     */
    public String getVectorizerName() {
        return this.vectorizerName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.vectorizerName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorSearchVectorizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorSearchVectorizer if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorSearchVectorizer.
     */
    public static VectorSearchVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("azureOpenAI".equals(discriminatorValue)) {
                    return AzureOpenAIVectorizer.fromJson(readerToUse.reset());
                } else if ("customWebApi".equals(discriminatorValue)) {
                    return WebApiVectorizer.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static VectorSearchVectorizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (vectorizerNameFound) {
                VectorSearchVectorizer deserializedVectorSearchVectorizer = new VectorSearchVectorizer(vectorizerName);
                deserializedVectorSearchVectorizer.kind = kind;

                return deserializedVectorSearchVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
