// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies a user-defined vectorizer for generating the vector embedding of a query string. Integration of an external
 * vectorizer is achieved using the custom Web API interface of a skillset.
 */
@Fluent
public final class WebApiVectorizer extends VectorSearchVectorizer {
    /*
     * The name of the kind of vectorization method being configured for use with vector search.
     */
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.CUSTOM_WEB_API;

    /*
     * Specifies the properties of the user-defined vectorizer.
     */
    private WebApiVectorizerParameters webApiParameters;

    /**
     * Creates an instance of WebApiVectorizer class.
     * 
     * @param vectorizerName the vectorizerName value to set.
     */
    public WebApiVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    /**
     * Get the kind property: The name of the kind of vectorization method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    /**
     * Get the webApiParameters property: Specifies the properties of the user-defined vectorizer.
     * 
     * @return the webApiParameters value.
     */
    public WebApiVectorizerParameters getWebApiParameters() {
        return this.webApiParameters;
    }

    /**
     * Set the webApiParameters property: Specifies the properties of the user-defined vectorizer.
     * 
     * @param webApiParameters the webApiParameters value to set.
     * @return the WebApiVectorizer object itself.
     */
    public WebApiVectorizer setWebApiParameters(WebApiVectorizerParameters webApiParameters) {
        this.webApiParameters = webApiParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("customWebApiParameters", this.webApiParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebApiVectorizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebApiVectorizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebApiVectorizer.
     */
    public static WebApiVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.CUSTOM_WEB_API;
            WebApiVectorizerParameters webApiParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                } else if ("customWebApiParameters".equals(fieldName)) {
                    webApiParameters = WebApiVectorizerParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (vectorizerNameFound) {
                WebApiVectorizer deserializedWebApiVectorizer = new WebApiVectorizer(vectorizerName);
                deserializedWebApiVectorizer.kind = kind;
                deserializedWebApiVectorizer.webApiParameters = webApiParameters;

                return deserializedWebApiVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
