// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * An answer is a text passage extracted from the contents of the most relevant documents that matched the query.
 * Answers are extracted from the top search results. Answer candidates are scored and the top answers are selected.
 */
@Fluent
public final class QueryAnswerResult implements JsonSerializable<QueryAnswerResult> {
    /*
     * The score value represents how relevant the answer is to the query relative to other answers returned for the
     * query.
     */
    private Double score;

    /*
     * The key of the document the answer was extracted from.
     */
    private String key;

    /*
     * The text passage extracted from the document contents as the answer.
     */
    private String text;

    /*
     * Same text passage as in the Text property with highlighted text phrases most relevant to the query.
     */
    private String highlights;

    /*
     * An answer is a text passage extracted from the contents of the most relevant documents that matched the query.
     * Answers are extracted from the top search results. Answer candidates are scored and the top answers are selected.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of QueryAnswerResult class.
     */
    public QueryAnswerResult() {
    }

    /**
     * Get the score property: The score value represents how relevant the answer is to the query relative to other
     * answers returned for the query.
     * 
     * @return the score value.
     */
    public Double getScore() {
        return this.score;
    }

    /**
     * Get the key property: The key of the document the answer was extracted from.
     * 
     * @return the key value.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Get the text property: The text passage extracted from the document contents as the answer.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Get the highlights property: Same text passage as in the Text property with highlighted text phrases most
     * relevant to the query.
     * 
     * @return the highlights value.
     */
    public String getHighlights() {
        return this.highlights;
    }

    /**
     * Get the additionalProperties property: An answer is a text passage extracted from the contents of the most
     * relevant documents that matched the query. Answers are extracted from the top search results. Answer candidates
     * are scored and the top answers are selected.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryAnswerResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryAnswerResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryAnswerResult.
     */
    public static QueryAnswerResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryAnswerResult deserializedQueryAnswerResult = new QueryAnswerResult();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("score".equals(fieldName)) {
                    deserializedQueryAnswerResult.score = reader.getNullable(JsonReader::getDouble);
                } else if ("key".equals(fieldName)) {
                    deserializedQueryAnswerResult.key = reader.getString();
                } else if ("text".equals(fieldName)) {
                    deserializedQueryAnswerResult.text = reader.getString();
                } else if ("highlights".equals(fieldName)) {
                    deserializedQueryAnswerResult.highlights = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedQueryAnswerResult.additionalProperties = additionalProperties;

            return deserializedQueryAnswerResult;
        });
    }
}
