// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of partial response that was returned for a semantic ranking request.
 */
public final class SemanticSearchResultsType extends ExpandableStringEnum<SemanticSearchResultsType> {
    /**
     * Results without any semantic enrichment or reranking.
     */
    public static final SemanticSearchResultsType BASE_RESULTS = fromString("baseResults");

    /**
     * Results have been reranked with the reranker model and will include semantic captions. They will not include any
     * answers, answers highlights or caption highlights.
     */
    public static final SemanticSearchResultsType RERANKED_RESULTS = fromString("rerankedResults");

    /**
     * Creates a new instance of SemanticSearchResultsType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SemanticSearchResultsType() {
    }

    /**
     * Creates or finds a SemanticSearchResultsType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SemanticSearchResultsType.
     */
    public static SemanticSearchResultsType fromString(String name) {
        return fromString(name, SemanticSearchResultsType.class);
    }

    /**
     * Gets known SemanticSearchResultsType values.
     * 
     * @return known SemanticSearchResultsType values.
     */
    public static Collection<SemanticSearchResultsType> values() {
        return values(SemanticSearchResultsType.class);
    }
}
