/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.FreshnessScoringParameters;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import java.io.IOException;
import java.util.ArrayList;

public final class FreshnessScoringFunction
extends ScoringFunction {
    private String type = "freshness";
    private final FreshnessScoringParameters parameters;

    public FreshnessScoringFunction(String fieldName, double boost, FreshnessScoringParameters parameters) {
        super(fieldName, boost);
        this.parameters = parameters;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public FreshnessScoringParameters getParameters() {
        return this.parameters;
    }

    @Override
    public FreshnessScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        super.setInterpolation(interpolation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.getFieldName());
        jsonWriter.writeDoubleField("boost", this.getBoost());
        jsonWriter.writeStringField("interpolation", this.getInterpolation() == null ? null : this.getInterpolation().toString());
        jsonWriter.writeJsonField("freshness", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static FreshnessScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (FreshnessScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            ScoringFunctionInterpolation interpolation = null;
            boolean parametersFound = false;
            FreshnessScoringParameters parameters = null;
            String type = "freshness";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                if ("freshness".equals(jsonFieldName)) {
                    parameters = FreshnessScoringParameters.fromJson(reader);
                    parametersFound = true;
                    continue;
                }
                if ("type".equals(jsonFieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound && parametersFound) {
                FreshnessScoringFunction deserializedFreshnessScoringFunction = new FreshnessScoringFunction(fieldName, boost, parameters);
                deserializedFreshnessScoringFunction.setInterpolation(interpolation);
                deserializedFreshnessScoringFunction.type = type;
                return deserializedFreshnessScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            if (!parametersFound) {
                missingProperties.add("freshness");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

