/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public final class IndexingResult
implements JsonSerializable<IndexingResult>,
Serializable {
    private final String key;
    private String errorMessage;
    private final boolean succeeded;
    private final int statusCode;
    private static final long serialVersionUID = -8604424005271188140L;

    public IndexingResult(String key, boolean succeeded, int statusCode) {
        this.key = key;
        this.succeeded = succeeded;
        this.statusCode = statusCode;
    }

    public String getKey() {
        return this.key;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static IndexingResult fromJson(JsonReader jsonReader) throws IOException {
        return (IndexingResult)jsonReader.readObject(reader -> {
            boolean keyFound = false;
            String key = null;
            boolean succeededFound = false;
            boolean succeeded = false;
            boolean statusCodeFound = false;
            int statusCode = 0;
            String errorMessage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    succeeded = reader.getBoolean();
                    succeededFound = true;
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    statusCode = reader.getInt();
                    statusCodeFound = true;
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound && succeededFound && statusCodeFound) {
                IndexingResult deserializedIndexingResult = new IndexingResult(key, succeeded, statusCode);
                deserializedIndexingResult.errorMessage = errorMessage;
                return deserializedIndexingResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            if (!succeededFound) {
                missingProperties.add("status");
            }
            if (!statusCodeFound) {
                missingProperties.add("statusCode");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

