/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.DocumentKeysOrIds;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class IndexersImpl {
    private final IndexersService service;
    private final SearchServiceClientImpl client;

    IndexersImpl(SearchServiceClientImpl client) {
        this.service = (IndexersService)RestProxy.create(IndexersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.resetWithResponseAsync(indexerName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetWithResponseAsync(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.reset(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetAsync(String indexerName, RequestOptions requestOptions) {
        return this.resetWithResponseAsync(indexerName, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return this.resetWithResponseAsync(indexerName, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.resetSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reset(String indexerName, RequestOptions requestOptions) {
        this.resetWithResponse(indexerName, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetDocsWithResponseAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetDocsWithResponseAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.resetDocs(this.client.getEndpoint(), indexerName, overwrite, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", keysOrIds, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetDocsAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions) {
        return this.resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetDocsAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions, Context context) {
        return this.resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetDocsWithResponse(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.resetDocsSync(this.client.getEndpoint(), indexerName, overwrite, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", keysOrIds, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetDocs(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds, RequestOptions requestOptions) {
        this.resetDocsWithResponse(indexerName, overwrite, keysOrIds, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> runWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.runWithResponseAsync(indexerName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> runWithResponseAsync(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.run(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> runAsync(String indexerName, RequestOptions requestOptions) {
        return this.runWithResponseAsync(indexerName, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> runAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return this.runWithResponseAsync(indexerName, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> runWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.runSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void run(String indexerName, RequestOptions requestOptions) {
        this.runWithResponse(indexerName, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createOrUpdateWithResponseAsync(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createOrUpdateWithResponseAsync(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, "application/json; odata.metadata=minimal", indexer, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createOrUpdateAsync(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createOrUpdateAsync(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createOrUpdateWithResponse(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, "application/json; odata.metadata=minimal", indexer, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer createOrUpdate(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions) {
        return (SearchIndexer)this.createOrUpdateWithResponse(indexerName, indexer, ifMatch, ifNoneMatch, skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(indexerName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> getWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(indexerName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> getWithResponseAsync(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> getAsync(String indexerName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(indexerName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> getAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(indexerName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> getWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer get(String indexerName, RequestOptions requestOptions) {
        return (SearchIndexer)this.getWithResponse(indexerName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListIndexersResult>> listWithResponseAsync(String select, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.listWithResponseAsync(select, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListIndexersResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListIndexersResult> listAsync(String select, RequestOptions requestOptions) {
        return this.listWithResponseAsync(select, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((ListIndexersResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListIndexersResult> listAsync(String select, RequestOptions requestOptions, Context context) {
        return this.listWithResponseAsync(select, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((ListIndexersResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListIndexersResult> listWithResponse(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.listSync(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListIndexersResult list(String select, RequestOptions requestOptions) {
        return (ListIndexersResult)this.listWithResponse(select, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createWithResponseAsync(SearchIndexer indexer, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(indexer, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createWithResponseAsync(SearchIndexer indexer, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", indexer, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createAsync(SearchIndexer indexer, RequestOptions requestOptions) {
        return this.createWithResponseAsync(indexer, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexer> createAsync(SearchIndexer indexer, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(indexer, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexer)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexer> createWithResponse(SearchIndexer indexer, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", indexer, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexer create(SearchIndexer indexer, RequestOptions requestOptions) {
        return (SearchIndexer)this.createWithResponse(indexer, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerStatus>> getStatusWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getStatusWithResponseAsync(indexerName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexerStatus>> getStatusWithResponseAsync(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getStatus(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerStatus> getStatusAsync(String indexerName, RequestOptions requestOptions) {
        return this.getStatusWithResponseAsync(indexerName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexerStatus> getStatusAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return this.getStatusWithResponseAsync(indexerName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SearchIndexerStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexerStatus> getStatusWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getStatusSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexerStatus getStatus(String indexerName, RequestOptions requestOptions) {
        return (SearchIndexerStatus)this.getStatusWithResponse(indexerName, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientI")
    public static interface IndexersService {
        @Post(value="/indexers('{indexerName}')/search.reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> reset(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/indexers('{indexerName}')/search.reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> resetSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/indexers('{indexerName}')/search.resetdocs")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> resetDocs(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @QueryParam(value="overwrite") Boolean var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") DocumentKeysOrIds var7, Context var8);

        @Post(value="/indexers('{indexerName}')/search.resetdocs")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> resetDocsSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @QueryParam(value="overwrite") Boolean var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") DocumentKeysOrIds var7, Context var8);

        @Post(value="/indexers('{indexerName}')/search.run")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> run(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/indexers('{indexerName}')/search.run")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> runSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexer>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="ignoreResetRequirements") Boolean var8, @QueryParam(value="disableCacheReprocessingChangeDetection") Boolean var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") SearchIndexer var11, Context var12);

        @Put(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexer> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="ignoreResetRequirements") Boolean var8, @QueryParam(value="disableCacheReprocessingChangeDetection") Boolean var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") SearchIndexer var11, Context var12);

        @Delete(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexer>> get(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/indexers('{indexerName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexer> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/indexers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListIndexersResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/indexers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListIndexersResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/indexers")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexer>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexer var5, Context var6);

        @Post(value="/indexers")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexer> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SearchIndexer var5, Context var6);

        @Get(value="/indexers('{indexerName}')/search.status")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SearchIndexerStatus>> getStatus(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/indexers('{indexerName}')/search.status")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SearchIndexerStatus> getStatusSync(@HostParam(value="endpoint") String var1, @PathParam(value="indexerName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

