/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CognitiveServicesAccount;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;
import java.util.ArrayList;

public final class AIServicesAccountIdentity
extends CognitiveServicesAccount {
    private String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";
    private final SearchIndexerDataIdentity identity;
    private final String subdomainUrl;

    public AIServicesAccountIdentity(SearchIndexerDataIdentity identity, String subdomainUrl) {
        this.identity = identity;
        this.subdomainUrl = subdomainUrl;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    public String getSubdomainUrl() {
        return this.subdomainUrl;
    }

    @Override
    public AIServicesAccountIdentity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("subdomainUrl", this.subdomainUrl);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static AIServicesAccountIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (AIServicesAccountIdentity)jsonReader.readObject(reader -> {
            String description = null;
            boolean identityFound = false;
            SearchIndexerDataIdentity identity = null;
            boolean subdomainUrlFound = false;
            String subdomainUrl = null;
            String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                    identityFound = true;
                    continue;
                }
                if ("subdomainUrl".equals(fieldName)) {
                    subdomainUrl = reader.getString();
                    subdomainUrlFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (identityFound && subdomainUrlFound) {
                AIServicesAccountIdentity deserializedAIServicesAccountIdentity = new AIServicesAccountIdentity(identity, subdomainUrl);
                deserializedAIServicesAccountIdentity.setDescription(description);
                deserializedAIServicesAccountIdentity.odataType = odataType;
                return deserializedAIServicesAccountIdentity;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!identityFound) {
                missingProperties.add("identity");
            }
            if (!subdomainUrlFound) {
                missingProperties.add("subdomainUrl");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

