/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AIServicesVisionParameters;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import com.azure.search.documents.indexes.models.VectorSearchVectorizerKind;
import java.io.IOException;

public final class AIServicesVisionVectorizer
extends VectorSearchVectorizer {
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AISERVICES_VISION;
    private AIServicesVisionParameters aIServicesVisionParameters;

    public AIServicesVisionVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    public AIServicesVisionParameters getAIServicesVisionParameters() {
        return this.aIServicesVisionParameters;
    }

    public AIServicesVisionVectorizer setAIServicesVisionParameters(AIServicesVisionParameters aIServicesVisionParameters) {
        this.aIServicesVisionParameters = aIServicesVisionParameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("aiServicesVisionParameters", (JsonSerializable)this.aIServicesVisionParameters);
        return jsonWriter.writeEndObject();
    }

    public static AIServicesVisionVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return (AIServicesVisionVectorizer)jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AISERVICES_VISION;
            AIServicesVisionParameters aIServicesVisionParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                    continue;
                }
                if ("aiServicesVisionParameters".equals(fieldName)) {
                    aIServicesVisionParameters = AIServicesVisionParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorizerNameFound) {
                AIServicesVisionVectorizer deserializedAIServicesVisionVectorizer = new AIServicesVisionVectorizer(vectorizerName);
                deserializedAIServicesVisionVectorizer.kind = kind;
                deserializedAIServicesVisionVectorizer.aIServicesVisionParameters = aIServicesVisionParameters;
                return deserializedAIServicesVisionVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

