/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AIStudioModelCatalogName;
import java.io.IOException;
import java.time.Duration;

public final class AzureMachineLearningParameters
implements JsonSerializable<AzureMachineLearningParameters> {
    private final String scoringUri;
    private String authenticationKey;
    private String resourceId;
    private Duration timeout;
    private String region;
    private AIStudioModelCatalogName modelName;

    public AzureMachineLearningParameters(String scoringUri) {
        this.scoringUri = scoringUri;
    }

    public String getScoringUri() {
        return this.scoringUri;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public AzureMachineLearningParameters setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public AzureMachineLearningParameters setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public AzureMachineLearningParameters setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public AzureMachineLearningParameters setRegion(String region) {
        this.region = region;
        return this;
    }

    public AIStudioModelCatalogName getModelName() {
        return this.modelName;
    }

    public AzureMachineLearningParameters setModelName(AIStudioModelCatalogName modelName) {
        this.modelName = modelName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.scoringUri);
        jsonWriter.writeStringField("key", this.authenticationKey);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("modelName", this.modelName == null ? null : this.modelName.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureMachineLearningParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMachineLearningParameters)jsonReader.readObject(reader -> {
            boolean scoringUriFound = false;
            String scoringUri = null;
            String authenticationKey = null;
            String resourceId = null;
            Duration timeout = null;
            String region = null;
            AIStudioModelCatalogName modelName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    scoringUri = reader.getString();
                    scoringUriFound = true;
                    continue;
                }
                if ("key".equals(fieldName)) {
                    authenticationKey = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    resourceId = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    timeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    region = reader.getString();
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    modelName = AIStudioModelCatalogName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (scoringUriFound) {
                AzureMachineLearningParameters deserializedAzureMachineLearningParameters = new AzureMachineLearningParameters(scoringUri);
                deserializedAzureMachineLearningParameters.authenticationKey = authenticationKey;
                deserializedAzureMachineLearningParameters.resourceId = resourceId;
                deserializedAzureMachineLearningParameters.timeout = timeout;
                deserializedAzureMachineLearningParameters.region = region;
                deserializedAzureMachineLearningParameters.modelName = modelName;
                return deserializedAzureMachineLearningParameters;
            }
            throw new IllegalStateException("Missing required property: uri");
        });
    }
}

