/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureMachineLearningParameters;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import com.azure.search.documents.indexes.models.VectorSearchVectorizerKind;
import java.io.IOException;

public final class AzureMachineLearningVectorizer
extends VectorSearchVectorizer {
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AML;
    private AzureMachineLearningParameters aMLParameters;

    public AzureMachineLearningVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    public AzureMachineLearningParameters getAMLParameters() {
        return this.aMLParameters;
    }

    public AzureMachineLearningVectorizer setAMLParameters(AzureMachineLearningParameters aMLParameters) {
        this.aMLParameters = aMLParameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("amlParameters", (JsonSerializable)this.aMLParameters);
        return jsonWriter.writeEndObject();
    }

    public static AzureMachineLearningVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMachineLearningVectorizer)jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AML;
            AzureMachineLearningParameters aMLParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                    continue;
                }
                if ("amlParameters".equals(fieldName)) {
                    aMLParameters = AzureMachineLearningParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorizerNameFound) {
                AzureMachineLearningVectorizer deserializedAzureMachineLearningVectorizer = new AzureMachineLearningVectorizer(vectorizerName);
                deserializedAzureMachineLearningVectorizer.kind = kind;
                deserializedAzureMachineLearningVectorizer.aMLParameters = aMLParameters;
                return deserializedAzureMachineLearningVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

