/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchCompressionRescoreStorageMethod;
import java.io.IOException;

public final class RescoringOptions
implements JsonSerializable<RescoringOptions> {
    private Boolean enableRescoring;
    private Double defaultOversampling;
    private VectorSearchCompressionRescoreStorageMethod rescoreStorageMethod;

    public Boolean isEnableRescoring() {
        return this.enableRescoring;
    }

    public RescoringOptions setEnableRescoring(Boolean enableRescoring) {
        this.enableRescoring = enableRescoring;
        return this;
    }

    public Double getDefaultOversampling() {
        return this.defaultOversampling;
    }

    public RescoringOptions setDefaultOversampling(Double defaultOversampling) {
        this.defaultOversampling = defaultOversampling;
        return this;
    }

    public VectorSearchCompressionRescoreStorageMethod getRescoreStorageMethod() {
        return this.rescoreStorageMethod;
    }

    public RescoringOptions setRescoreStorageMethod(VectorSearchCompressionRescoreStorageMethod rescoreStorageMethod) {
        this.rescoreStorageMethod = rescoreStorageMethod;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableRescoring", this.enableRescoring);
        jsonWriter.writeNumberField("defaultOversampling", (Number)this.defaultOversampling);
        jsonWriter.writeStringField("rescoreStorageMethod", this.rescoreStorageMethod == null ? null : this.rescoreStorageMethod.toString());
        return jsonWriter.writeEndObject();
    }

    public static RescoringOptions fromJson(JsonReader jsonReader) throws IOException {
        return (RescoringOptions)jsonReader.readObject(reader -> {
            RescoringOptions deserializedRescoringOptions = new RescoringOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableRescoring".equals(fieldName)) {
                    deserializedRescoringOptions.enableRescoring = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultOversampling".equals(fieldName)) {
                    deserializedRescoringOptions.defaultOversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("rescoreStorageMethod".equals(fieldName)) {
                    deserializedRescoringOptions.rescoreStorageMethod = VectorSearchCompressionRescoreStorageMethod.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRescoringOptions;
        });
    }
}

