/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilter;
import com.azure.search.documents.indexes.models.CorsOptions;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.LexicalNormalizer;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.ScoringProfile;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import com.azure.search.documents.indexes.models.SearchSuggester;
import com.azure.search.documents.indexes.models.SemanticSearch;
import com.azure.search.documents.indexes.models.SimilarityAlgorithm;
import com.azure.search.documents.indexes.models.TokenFilter;
import com.azure.search.documents.indexes.models.VectorSearch;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class SearchIndex
implements JsonSerializable<SearchIndex> {
    private final String name;
    private List<SearchField> fields;
    private List<ScoringProfile> scoringProfiles;
    private String defaultScoringProfile;
    private CorsOptions corsOptions;
    private List<SearchSuggester> suggesters;
    private List<LexicalAnalyzer> analyzers;
    private List<LexicalTokenizer> tokenizers;
    private List<TokenFilter> tokenFilters;
    private List<CharFilter> charFilters;
    private List<LexicalNormalizer> normalizers;
    private SearchResourceEncryptionKey encryptionKey;
    private SimilarityAlgorithm similarity;
    private SemanticSearch semanticSearch;
    private VectorSearch vectorSearch;
    private String eTag;

    public SearchIndex(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    public SearchIndex setFields(List<SearchField> fields) {
        this.fields = fields;
        return this;
    }

    public List<ScoringProfile> getScoringProfiles() {
        return this.scoringProfiles;
    }

    public SearchIndex setScoringProfiles(List<ScoringProfile> scoringProfiles) {
        this.scoringProfiles = scoringProfiles;
        return this;
    }

    public String getDefaultScoringProfile() {
        return this.defaultScoringProfile;
    }

    public SearchIndex setDefaultScoringProfile(String defaultScoringProfile) {
        this.defaultScoringProfile = defaultScoringProfile;
        return this;
    }

    public CorsOptions getCorsOptions() {
        return this.corsOptions;
    }

    public SearchIndex setCorsOptions(CorsOptions corsOptions) {
        this.corsOptions = corsOptions;
        return this;
    }

    public List<SearchSuggester> getSuggesters() {
        return this.suggesters;
    }

    public SearchIndex setSuggesters(List<SearchSuggester> suggesters) {
        this.suggesters = suggesters;
        return this;
    }

    public List<LexicalAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public SearchIndex setAnalyzers(List<LexicalAnalyzer> analyzers) {
        this.analyzers = analyzers;
        return this;
    }

    public List<LexicalTokenizer> getTokenizers() {
        return this.tokenizers;
    }

    public SearchIndex setTokenizers(List<LexicalTokenizer> tokenizers) {
        this.tokenizers = tokenizers;
        return this;
    }

    public List<TokenFilter> getTokenFilters() {
        return this.tokenFilters;
    }

    public SearchIndex setTokenFilters(List<TokenFilter> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilter> getCharFilters() {
        return this.charFilters;
    }

    public SearchIndex setCharFilters(List<CharFilter> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    public List<LexicalNormalizer> getNormalizers() {
        return this.normalizers;
    }

    public SearchIndex setNormalizers(List<LexicalNormalizer> normalizers) {
        this.normalizers = normalizers;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SearchIndex setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public SimilarityAlgorithm getSimilarity() {
        return this.similarity;
    }

    public SearchIndex setSimilarity(SimilarityAlgorithm similarity) {
        this.similarity = similarity;
        return this;
    }

    public SemanticSearch getSemanticSearch() {
        return this.semanticSearch;
    }

    public SearchIndex setSemanticSearch(SemanticSearch semanticSearch) {
        this.semanticSearch = semanticSearch;
        return this;
    }

    public VectorSearch getVectorSearch() {
        return this.vectorSearch;
    }

    public SearchIndex setVectorSearch(VectorSearch vectorSearch) {
        this.vectorSearch = vectorSearch;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndex setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("scoringProfiles", this.scoringProfiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("defaultScoringProfile", this.defaultScoringProfile);
        jsonWriter.writeJsonField("corsOptions", (JsonSerializable)this.corsOptions);
        jsonWriter.writeArrayField("suggesters", this.suggesters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("analyzers", this.analyzers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tokenizers", this.tokenizers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("charFilters", this.charFilters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("normalizers", this.normalizers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        jsonWriter.writeJsonField("similarity", (JsonSerializable)this.similarity);
        jsonWriter.writeJsonField("semantic", (JsonSerializable)this.semanticSearch);
        jsonWriter.writeJsonField("vectorSearch", (JsonSerializable)this.vectorSearch);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndex fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndex)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            List fields = null;
            List scoringProfiles = null;
            String defaultScoringProfile = null;
            CorsOptions corsOptions = null;
            List suggesters = null;
            List analyzers = null;
            List tokenizers = null;
            List tokenFilters = null;
            List charFilters = null;
            List normalizers = null;
            SearchResourceEncryptionKey encryptionKey = null;
            SimilarityAlgorithm similarity = null;
            SemanticSearch semanticSearch = null;
            VectorSearch vectorSearch = null;
            String eTag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.readArray(reader1 -> SearchField.fromJson(reader1));
                    continue;
                }
                if ("scoringProfiles".equals(fieldName)) {
                    scoringProfiles = reader.readArray(reader1 -> ScoringProfile.fromJson(reader1));
                    continue;
                }
                if ("defaultScoringProfile".equals(fieldName)) {
                    defaultScoringProfile = reader.getString();
                    continue;
                }
                if ("corsOptions".equals(fieldName)) {
                    corsOptions = CorsOptions.fromJson(reader);
                    continue;
                }
                if ("suggesters".equals(fieldName)) {
                    suggesters = reader.readArray(reader1 -> SearchSuggester.fromJson(reader1));
                    continue;
                }
                if ("analyzers".equals(fieldName)) {
                    analyzers = reader.readArray(reader1 -> LexicalAnalyzer.fromJson(reader1));
                    continue;
                }
                if ("tokenizers".equals(fieldName)) {
                    tokenizers = reader.readArray(reader1 -> LexicalTokenizer.fromJson(reader1));
                    continue;
                }
                if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilter.fromJson(reader1));
                    continue;
                }
                if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilter.fromJson(reader1));
                    continue;
                }
                if ("normalizers".equals(fieldName)) {
                    normalizers = reader.readArray(reader1 -> LexicalNormalizer.fromJson(reader1));
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("similarity".equals(fieldName)) {
                    similarity = SimilarityAlgorithm.fromJson(reader);
                    continue;
                }
                if ("semantic".equals(fieldName)) {
                    semanticSearch = SemanticSearch.fromJson(reader);
                    continue;
                }
                if ("vectorSearch".equals(fieldName)) {
                    vectorSearch = VectorSearch.fromJson(reader);
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                SearchIndex deserializedSearchIndex = new SearchIndex(name);
                deserializedSearchIndex.fields = fields;
                deserializedSearchIndex.scoringProfiles = scoringProfiles;
                deserializedSearchIndex.defaultScoringProfile = defaultScoringProfile;
                deserializedSearchIndex.corsOptions = corsOptions;
                deserializedSearchIndex.suggesters = suggesters;
                deserializedSearchIndex.analyzers = analyzers;
                deserializedSearchIndex.tokenizers = tokenizers;
                deserializedSearchIndex.tokenFilters = tokenFilters;
                deserializedSearchIndex.charFilters = charFilters;
                deserializedSearchIndex.normalizers = normalizers;
                deserializedSearchIndex.encryptionKey = encryptionKey;
                deserializedSearchIndex.similarity = similarity;
                deserializedSearchIndex.semanticSearch = semanticSearch;
                deserializedSearchIndex.vectorSearch = vectorSearch;
                deserializedSearchIndex.eTag = eTag;
                return deserializedSearchIndex;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public SearchIndex(String name, List<SearchField> fields) {
        this.name = name;
        this.fields = fields;
    }

    public SearchIndex setFields(SearchField ... fields) {
        this.fields = fields == null ? null : Arrays.asList(fields);
        return this;
    }

    public SearchIndex setScoringProfiles(ScoringProfile ... scoringProfiles) {
        this.scoringProfiles = scoringProfiles == null ? null : Arrays.asList(scoringProfiles);
        return this;
    }

    public SearchIndex setSuggesters(SearchSuggester ... suggesters) {
        this.suggesters = suggesters == null ? null : Arrays.asList(suggesters);
        return this;
    }

    public SearchIndex setAnalyzers(LexicalAnalyzer ... analyzers) {
        this.analyzers = analyzers == null ? null : Arrays.asList(analyzers);
        return this;
    }

    public SearchIndex setTokenizers(LexicalTokenizer ... tokenizers) {
        this.tokenizers = tokenizers == null ? null : Arrays.asList(tokenizers);
        return this;
    }

    public SearchIndex setTokenFilters(TokenFilter ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    public SearchIndex setCharFilters(CharFilter ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }
}

