// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

/**
 * Initializes a new instance of the KnowledgeAgentRetrievalClient type.
 */
public final class KnowledgeAgentRetrievalClientImpl {
    /**
     * The endpoint URL of the search service.
     */
    private final String endpoint;

    /**
     * Gets The endpoint URL of the search service.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * The name of the agent.
     */
    private final String agentName;

    /**
     * Gets The name of the agent.
     * 
     * @return the agentName value.
     */
    public String getAgentName() {
        return this.agentName;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The KnowledgeRetrievalsImpl object to access its operations.
     */
    private final KnowledgeRetrievalsImpl knowledgeRetrievals;

    /**
     * Gets the KnowledgeRetrievalsImpl object to access its operations.
     * 
     * @return the KnowledgeRetrievalsImpl object.
     */
    public KnowledgeRetrievalsImpl getKnowledgeRetrievals() {
        return this.knowledgeRetrievals;
    }

    /**
     * Initializes an instance of KnowledgeAgentRetrievalClient client.
     * 
     * @param endpoint The endpoint URL of the search service.
     * @param agentName The name of the agent.
     * @param apiVersion Api Version.
     */
    public KnowledgeAgentRetrievalClientImpl(String endpoint, String agentName, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, agentName, apiVersion);
    }

    /**
     * Initializes an instance of KnowledgeAgentRetrievalClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint The endpoint URL of the search service.
     * @param agentName The name of the agent.
     * @param apiVersion Api Version.
     */
    public KnowledgeAgentRetrievalClientImpl(HttpPipeline httpPipeline, String endpoint, String agentName,
        String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, agentName, apiVersion);
    }

    /**
     * Initializes an instance of KnowledgeAgentRetrievalClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint The endpoint URL of the search service.
     * @param agentName The name of the agent.
     * @param apiVersion Api Version.
     */
    public KnowledgeAgentRetrievalClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        String endpoint, String agentName, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.agentName = agentName;
        this.apiVersion = apiVersion;
        this.knowledgeRetrievals = new KnowledgeRetrievalsImpl(this);
    }
}
