// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base type for activity records.
 */
@Fluent
public class KnowledgeAgentActivityRecord implements JsonSerializable<KnowledgeAgentActivityRecord> {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "KnowledgeAgentActivityRecord";

    /*
     * The ID of the activity record.
     */
    @Generated
    private final int id;

    /*
     * The elapsed time in milliseconds for the retrieval activity.
     */
    @Generated
    private Integer elapsedMs;

    /**
     * Creates an instance of KnowledgeAgentActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeAgentActivityRecord(int id) {
        this.id = id;
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the id property: The ID of the activity record.
     * 
     * @return the id value.
     */
    @Generated
    public int getId() {
        return this.id;
    }

    /**
     * Get the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @return the elapsedMs value.
     */
    @Generated
    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    /**
     * Set the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @param elapsedMs the elapsedMs value to set.
     * @return the KnowledgeAgentActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("elapsedMs", this.elapsedMs);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentActivityRecord if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentActivityRecord.
     */
    @Generated
    public static KnowledgeAgentActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("KnowledgeAgentRetrievalActivityRecord".equals(discriminatorValue)) {
                    return KnowledgeAgentRetrievalActivityRecord.fromJsonKnownDiscriminator(readerToUse.reset());
                } else if ("searchIndex".equals(discriminatorValue)) {
                    return KnowledgeAgentSearchIndexActivityRecord.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return KnowledgeAgentAzureBlobActivityRecord.fromJson(readerToUse.reset());
                } else if ("modelQueryPlanning".equals(discriminatorValue)) {
                    return KnowledgeAgentModelQueryPlanningActivityRecord.fromJson(readerToUse.reset());
                } else if ("modelAnswerSynthesis".equals(discriminatorValue)) {
                    return KnowledgeAgentModelAnswerSynthesisActivityRecord.fromJson(readerToUse.reset());
                } else if ("semanticReranker".equals(discriminatorValue)) {
                    return KnowledgeAgentSemanticRerankerActivityRecord.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeAgentActivityRecord fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = null;
            Integer elapsedMs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeAgentActivityRecord deserializedKnowledgeAgentActivityRecord
                    = new KnowledgeAgentActivityRecord(id);
                deserializedKnowledgeAgentActivityRecord.type = type;
                deserializedKnowledgeAgentActivityRecord.elapsedMs = elapsedMs;

                return deserializedKnowledgeAgentActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
