// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a azure blob retrieval activity record.
 */
@Fluent
public final class KnowledgeAgentAzureBlobActivityRecord extends KnowledgeAgentRetrievalActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "azureBlob";

    /*
     * The azure blob arguments for the retrieval activity.
     */
    @Generated
    private KnowledgeAgentAzureBlobActivityArguments azureBlobArguments;

    /**
     * Creates an instance of KnowledgeAgentAzureBlobActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeAgentAzureBlobActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the azureBlobArguments property: The azure blob arguments for the retrieval activity.
     * 
     * @return the azureBlobArguments value.
     */
    @Generated
    public KnowledgeAgentAzureBlobActivityArguments getAzureBlobArguments() {
        return this.azureBlobArguments;
    }

    /**
     * Set the azureBlobArguments property: The azure blob arguments for the retrieval activity.
     * 
     * @param azureBlobArguments the azureBlobArguments value to set.
     * @return the KnowledgeAgentAzureBlobActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentAzureBlobActivityRecord
        setAzureBlobArguments(KnowledgeAgentAzureBlobActivityArguments azureBlobArguments) {
        this.azureBlobArguments = azureBlobArguments;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentAzureBlobActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        super.setKnowledgeSourceName(knowledgeSourceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentAzureBlobActivityRecord setQueryTime(OffsetDateTime queryTime) {
        super.setQueryTime(queryTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentAzureBlobActivityRecord setCount(Integer count) {
        super.setCount(count);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentAzureBlobActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeStringField("queryTime",
            getQueryTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getQueryTime()));
        jsonWriter.writeNumberField("count", getCount());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("azureBlobArguments", this.azureBlobArguments);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentAzureBlobActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentAzureBlobActivityRecord if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentAzureBlobActivityRecord.
     */
    @Generated
    public static KnowledgeAgentAzureBlobActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            String type = "azureBlob";
            KnowledgeAgentAzureBlobActivityArguments azureBlobArguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                } else if ("queryTime".equals(fieldName)) {
                    queryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("azureBlobArguments".equals(fieldName)) {
                    azureBlobArguments = KnowledgeAgentAzureBlobActivityArguments.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeAgentAzureBlobActivityRecord deserializedKnowledgeAgentAzureBlobActivityRecord
                    = new KnowledgeAgentAzureBlobActivityRecord(id);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setKnowledgeSourceName(knowledgeSourceName);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setQueryTime(queryTime);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setCount(count);
                deserializedKnowledgeAgentAzureBlobActivityRecord.type = type;
                deserializedKnowledgeAgentAzureBlobActivityRecord.azureBlobArguments = azureBlobArguments;

                return deserializedKnowledgeAgentAzureBlobActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
