// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Represents an Azure Search document reference.
 */
@Fluent
public final class KnowledgeAgentAzureSearchDocReference extends KnowledgeAgentReference {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "AzureSearchDoc";

    /*
     * The document key for the reference.
     */
    @Generated
    private String docKey;

    /*
     * Dictionary of <any>
     */
    @Generated
    private Map<String, Object> sourceData;

    /**
     * Creates an instance of KnowledgeAgentAzureSearchDocReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeAgentAzureSearchDocReference(String id, int activitySource) {
        super(id, activitySource);
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the docKey property: The document key for the reference.
     * 
     * @return the docKey value.
     */
    @Generated
    public String getDocKey() {
        return this.docKey;
    }

    /**
     * Set the docKey property: The document key for the reference.
     * 
     * @param docKey the docKey value to set.
     * @return the KnowledgeAgentAzureSearchDocReference object itself.
     */
    @Generated
    public KnowledgeAgentAzureSearchDocReference setDocKey(String docKey) {
        this.docKey = docKey;
        return this;
    }

    /**
     * Get the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @return the sourceData value.
     */
    @Generated
    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    /**
     * Set the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @param sourceData the sourceData value to set.
     * @return the KnowledgeAgentAzureSearchDocReference object itself.
     */
    @Generated
    public KnowledgeAgentAzureSearchDocReference setSourceData(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeIntField("activitySource", getActivitySource());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("docKey", this.docKey);
        jsonWriter.writeMapField("sourceData", this.sourceData, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentAzureSearchDocReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentAzureSearchDocReference if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentAzureSearchDocReference.
     */
    @Generated
    public static KnowledgeAgentAzureSearchDocReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            String type = "AzureSearchDoc";
            String docKey = null;
            Map<String, Object> sourceData = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("docKey".equals(fieldName)) {
                    docKey = reader.getString();
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentAzureSearchDocReference deserializedKnowledgeAgentAzureSearchDocReference
                    = new KnowledgeAgentAzureSearchDocReference(id, activitySource);
                deserializedKnowledgeAgentAzureSearchDocReference.type = type;
                deserializedKnowledgeAgentAzureSearchDocReference.docKey = docKey;
                deserializedKnowledgeAgentAzureSearchDocReference.sourceData = sourceData;

                return deserializedKnowledgeAgentAzureSearchDocReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
