// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeAgentIndexParams model.
 */
@Fluent
public final class KnowledgeAgentIndexParams implements JsonSerializable<KnowledgeAgentIndexParams> {
    /*
     * The name of the index the params apply to.
     */
    @Generated
    private String indexName;

    /*
     * A filter condition applied to the index (e.g., 'State eq VA').
     */
    @Generated
    private String filterAddOn;

    /*
     * Limits the number of documents considered for ranking.
     */
    @Generated
    private Integer maxDocsForReranker;

    /*
     * A threshold for reranking results (range: 0-4).
     */
    @Generated
    private Float rerankerThreshold;

    /*
     * Indicates whether reference source data should be included.
     */
    @Generated
    private Boolean includeReferenceSourceData;

    /**
     * Creates an instance of KnowledgeAgentIndexParams class.
     */
    @Generated
    public KnowledgeAgentIndexParams() {
    }

    /**
     * Get the indexName property: The name of the index the params apply to.
     * 
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Set the indexName property: The name of the index the params apply to.
     * 
     * @param indexName the indexName value to set.
     * @return the KnowledgeAgentIndexParams object itself.
     */
    @Generated
    public KnowledgeAgentIndexParams setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    /**
     * Get the filterAddOn property: A filter condition applied to the index (e.g., 'State eq VA').
     * 
     * @return the filterAddOn value.
     */
    @Generated
    public String getFilterAddOn() {
        return this.filterAddOn;
    }

    /**
     * Set the filterAddOn property: A filter condition applied to the index (e.g., 'State eq VA').
     * 
     * @param filterAddOn the filterAddOn value to set.
     * @return the KnowledgeAgentIndexParams object itself.
     */
    @Generated
    public KnowledgeAgentIndexParams setFilterAddOn(String filterAddOn) {
        this.filterAddOn = filterAddOn;
        return this;
    }

    /**
     * Get the maxDocsForReranker property: Limits the number of documents considered for ranking.
     * 
     * @return the maxDocsForReranker value.
     */
    @Generated
    public Integer getMaxDocsForReranker() {
        return this.maxDocsForReranker;
    }

    /**
     * Set the maxDocsForReranker property: Limits the number of documents considered for ranking.
     * 
     * @param maxDocsForReranker the maxDocsForReranker value to set.
     * @return the KnowledgeAgentIndexParams object itself.
     */
    @Generated
    public KnowledgeAgentIndexParams setMaxDocsForReranker(Integer maxDocsForReranker) {
        this.maxDocsForReranker = maxDocsForReranker;
        return this;
    }

    /**
     * Get the rerankerThreshold property: A threshold for reranking results (range: 0-4).
     * 
     * @return the rerankerThreshold value.
     */
    @Generated
    public Float getRerankerThreshold() {
        return this.rerankerThreshold;
    }

    /**
     * Set the rerankerThreshold property: A threshold for reranking results (range: 0-4).
     * 
     * @param rerankerThreshold the rerankerThreshold value to set.
     * @return the KnowledgeAgentIndexParams object itself.
     */
    @Generated
    public KnowledgeAgentIndexParams setRerankerThreshold(Float rerankerThreshold) {
        this.rerankerThreshold = rerankerThreshold;
        return this;
    }

    /**
     * Get the includeReferenceSourceData property: Indicates whether reference source data should be included.
     * 
     * @return the includeReferenceSourceData value.
     */
    @Generated
    public Boolean isIncludeReferenceSourceData() {
        return this.includeReferenceSourceData;
    }

    /**
     * Set the includeReferenceSourceData property: Indicates whether reference source data should be included.
     * 
     * @param includeReferenceSourceData the includeReferenceSourceData value to set.
     * @return the KnowledgeAgentIndexParams object itself.
     */
    @Generated
    public KnowledgeAgentIndexParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        this.includeReferenceSourceData = includeReferenceSourceData;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("indexName", this.indexName);
        jsonWriter.writeStringField("filterAddOn", this.filterAddOn);
        jsonWriter.writeNumberField("maxDocsForReranker", this.maxDocsForReranker);
        jsonWriter.writeNumberField("rerankerThreshold", this.rerankerThreshold);
        jsonWriter.writeBooleanField("includeReferenceSourceData", this.includeReferenceSourceData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentIndexParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentIndexParams if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentIndexParams.
     */
    @Generated
    public static KnowledgeAgentIndexParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentIndexParams deserializedKnowledgeAgentIndexParams = new KnowledgeAgentIndexParams();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("indexName".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.indexName = reader.getString();
                } else if ("filterAddOn".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.filterAddOn = reader.getString();
                } else if ("maxDocsForReranker".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.maxDocsForReranker = reader.getNullable(JsonReader::getInt);
                } else if ("rerankerThreshold".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.rerankerThreshold = reader.getNullable(JsonReader::getFloat);
                } else if ("includeReferenceSourceData".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.includeReferenceSourceData
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentIndexParams;
        });
    }
}
