// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the type of the message content.
 */
@Immutable
public class KnowledgeAgentMessageContent implements JsonSerializable<KnowledgeAgentMessageContent> {
    /*
     * The type of the message
     */
    @Generated
    private KnowledgeAgentMessageContentType type
        = KnowledgeAgentMessageContentType.fromString("KnowledgeAgentMessageContent");

    /**
     * Creates an instance of KnowledgeAgentMessageContent class.
     */
    @Generated
    public KnowledgeAgentMessageContent() {
    }

    /**
     * Get the type property: The type of the message.
     * 
     * @return the type value.
     */
    @Generated
    public KnowledgeAgentMessageContentType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentMessageContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentMessageContent if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentMessageContent.
     */
    @Generated
    public static KnowledgeAgentMessageContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return KnowledgeAgentMessageTextContent.fromJson(readerToUse.reset());
                } else if ("image".equals(discriminatorValue)) {
                    return KnowledgeAgentMessageImageContent.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeAgentMessageContent fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentMessageContent deserializedKnowledgeAgentMessageContent = new KnowledgeAgentMessageContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedKnowledgeAgentMessageContent.type
                        = KnowledgeAgentMessageContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentMessageContent;
        });
    }
}
