// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Text message type.
 */
@Immutable
public final class KnowledgeAgentMessageImageContent extends KnowledgeAgentMessageContent {
    /*
     * The type of the message
     */
    @Generated
    private KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.IMAGE;

    /*
     * The image property.
     */
    @Generated
    private final KnowledgeAgentMessageImageContentImage image;

    /**
     * Creates an instance of KnowledgeAgentMessageImageContent class.
     * 
     * @param image the image value to set.
     */
    @Generated
    public KnowledgeAgentMessageImageContent(KnowledgeAgentMessageImageContentImage image) {
        this.image = image;
    }

    /**
     * Get the type property: The type of the message.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public KnowledgeAgentMessageContentType getType() {
        return this.type;
    }

    /**
     * Get the image property: The image property.
     * 
     * @return the image value.
     */
    @Generated
    public KnowledgeAgentMessageImageContentImage getImage() {
        return this.image;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image", this.image);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentMessageImageContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentMessageImageContent if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentMessageImageContent.
     */
    @Generated
    public static KnowledgeAgentMessageImageContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean imageFound = false;
            KnowledgeAgentMessageImageContentImage image = null;
            KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.IMAGE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("image".equals(fieldName)) {
                    image = KnowledgeAgentMessageImageContentImage.fromJson(reader);
                    imageFound = true;
                } else if ("type".equals(fieldName)) {
                    type = KnowledgeAgentMessageContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (imageFound) {
                KnowledgeAgentMessageImageContent deserializedKnowledgeAgentMessageImageContent
                    = new KnowledgeAgentMessageImageContent(image);
                deserializedKnowledgeAgentMessageImageContent.type = type;

                return deserializedKnowledgeAgentMessageImageContent;
            }
            throw new IllegalStateException("Missing required property: image");
        });
    }
}
