// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeAgentMessageImageContentImage model.
 */
@Immutable
public final class KnowledgeAgentMessageImageContentImage
    implements JsonSerializable<KnowledgeAgentMessageImageContentImage> {
    /*
     * The url of the image.
     */
    @Generated
    private final String url;

    /**
     * Creates an instance of KnowledgeAgentMessageImageContentImage class.
     * 
     * @param url the url value to set.
     */
    @Generated
    public KnowledgeAgentMessageImageContentImage(String url) {
        this.url = url;
    }

    /**
     * Get the url property: The url of the image.
     * 
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentMessageImageContentImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentMessageImageContentImage if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentMessageImageContentImage.
     */
    @Generated
    public static KnowledgeAgentMessageImageContentImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean urlFound = false;
            String url = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    urlFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (urlFound) {
                return new KnowledgeAgentMessageImageContentImage(url);
            }
            throw new IllegalStateException("Missing required property: url");
        });
    }
}
