// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Base type for references.
 */
@Fluent
public class KnowledgeAgentReference implements JsonSerializable<KnowledgeAgentReference> {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "KnowledgeAgentReference";

    /*
     * The ID of the reference.
     */
    @Generated
    private final String id;

    /*
     * The source activity ID for the reference.
     */
    @Generated
    private final int activitySource;

    /*
     * Dictionary of <any>
     */
    @Generated
    private Map<String, Object> sourceData;

    /*
     * The reranker score for the document reference.
     */
    @Generated
    private Float rerankerScore;

    /**
     * Creates an instance of KnowledgeAgentReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeAgentReference(String id, int activitySource) {
        this.id = id;
        this.activitySource = activitySource;
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the id property: The ID of the reference.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the activitySource property: The source activity ID for the reference.
     * 
     * @return the activitySource value.
     */
    @Generated
    public int getActivitySource() {
        return this.activitySource;
    }

    /**
     * Get the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @return the sourceData value.
     */
    @Generated
    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    /**
     * Set the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @param sourceData the sourceData value to set.
     * @return the KnowledgeAgentReference object itself.
     */
    @Generated
    public KnowledgeAgentReference setSourceData(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    /**
     * Get the rerankerScore property: The reranker score for the document reference.
     * 
     * @return the rerankerScore value.
     */
    @Generated
    public Float getRerankerScore() {
        return this.rerankerScore;
    }

    /**
     * Set the rerankerScore property: The reranker score for the document reference.
     * 
     * @param rerankerScore the rerankerScore value to set.
     * @return the KnowledgeAgentReference object itself.
     */
    @Generated
    public KnowledgeAgentReference setRerankerScore(Float rerankerScore) {
        this.rerankerScore = rerankerScore;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeIntField("activitySource", this.activitySource);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("sourceData", this.sourceData, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", this.rerankerScore);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentReference.
     */
    @Generated
    public static KnowledgeAgentReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("searchIndex".equals(discriminatorValue)) {
                    return KnowledgeAgentSearchIndexReference.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return KnowledgeAgentAzureBlobReference.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeAgentReference fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            String type = null;
            Map<String, Object> sourceData = null;
            Float rerankerScore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentReference deserializedKnowledgeAgentReference
                    = new KnowledgeAgentReference(id, activitySource);
                deserializedKnowledgeAgentReference.type = type;
                deserializedKnowledgeAgentReference.sourceData = sourceData;
                deserializedKnowledgeAgentReference.rerankerScore = rerankerScore;

                return deserializedKnowledgeAgentReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
