// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a retrieval activity record.
 */
@Fluent
public class KnowledgeAgentRetrievalActivityRecord extends KnowledgeAgentActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "KnowledgeAgentRetrievalActivityRecord";

    /*
     * The knowledge source for the retrieval activity.
     */
    @Generated
    private String knowledgeSourceName;

    /*
     * The query time for this retrieval activity.
     */
    @Generated
    private OffsetDateTime queryTime;

    /*
     * The count of documents retrieved that were sufficiently relevant to pass the reranker threshold.
     */
    @Generated
    private Integer count;

    /**
     * Creates an instance of KnowledgeAgentRetrievalActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeAgentRetrievalActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the knowledgeSourceName property: The knowledge source for the retrieval activity.
     * 
     * @return the knowledgeSourceName value.
     */
    @Generated
    public String getKnowledgeSourceName() {
        return this.knowledgeSourceName;
    }

    /**
     * Set the knowledgeSourceName property: The knowledge source for the retrieval activity.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     * @return the KnowledgeAgentRetrievalActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentRetrievalActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        this.knowledgeSourceName = knowledgeSourceName;
        return this;
    }

    /**
     * Get the queryTime property: The query time for this retrieval activity.
     * 
     * @return the queryTime value.
     */
    @Generated
    public OffsetDateTime getQueryTime() {
        return this.queryTime;
    }

    /**
     * Set the queryTime property: The query time for this retrieval activity.
     * 
     * @param queryTime the queryTime value to set.
     * @return the KnowledgeAgentRetrievalActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentRetrievalActivityRecord setQueryTime(OffsetDateTime queryTime) {
        this.queryTime = queryTime;
        return this;
    }

    /**
     * Get the count property: The count of documents retrieved that were sufficiently relevant to pass the reranker
     * threshold.
     * 
     * @return the count value.
     */
    @Generated
    public Integer getCount() {
        return this.count;
    }

    /**
     * Set the count property: The count of documents retrieved that were sufficiently relevant to pass the reranker
     * threshold.
     * 
     * @param count the count value to set.
     * @return the KnowledgeAgentRetrievalActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentRetrievalActivityRecord setCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentRetrievalActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("knowledgeSourceName", this.knowledgeSourceName);
        jsonWriter.writeStringField("queryTime",
            this.queryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queryTime));
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentRetrievalActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentRetrievalActivityRecord if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentRetrievalActivityRecord.
     */
    @Generated
    public static KnowledgeAgentRetrievalActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("searchIndex".equals(discriminatorValue)) {
                    return KnowledgeAgentSearchIndexActivityRecord.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return KnowledgeAgentAzureBlobActivityRecord.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeAgentRetrievalActivityRecord fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "KnowledgeAgentRetrievalActivityRecord";
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                } else if ("queryTime".equals(fieldName)) {
                    queryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeAgentRetrievalActivityRecord deserializedKnowledgeAgentRetrievalActivityRecord
                    = new KnowledgeAgentRetrievalActivityRecord(id);
                deserializedKnowledgeAgentRetrievalActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentRetrievalActivityRecord.type = type;
                deserializedKnowledgeAgentRetrievalActivityRecord.knowledgeSourceName = knowledgeSourceName;
                deserializedKnowledgeAgentRetrievalActivityRecord.queryTime = queryTime;
                deserializedKnowledgeAgentRetrievalActivityRecord.count = count;

                return deserializedKnowledgeAgentRetrievalActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
