// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The input contract for the retrieval request.
 */
@Fluent
public final class KnowledgeAgentRetrievalRequest implements JsonSerializable<KnowledgeAgentRetrievalRequest> {
    /*
     * The messages property.
     */
    @Generated
    private final List<KnowledgeAgentMessage> messages;

    /*
     * The knowledgeSourceParams property.
     */
    @Generated
    private List<KnowledgeSourceParams> knowledgeSourceParams;

    /**
     * Creates an instance of KnowledgeAgentRetrievalRequest class.
     * 
     * @param messages the messages value to set.
     */
    @Generated
    public KnowledgeAgentRetrievalRequest(List<KnowledgeAgentMessage> messages) {
        this.messages = messages;
    }

    /**
     * Get the messages property: The messages property.
     * 
     * @return the messages value.
     */
    @Generated
    public List<KnowledgeAgentMessage> getMessages() {
        return this.messages;
    }

    /**
     * Get the knowledgeSourceParams property: The knowledgeSourceParams property.
     * 
     * @return the knowledgeSourceParams value.
     */
    @Generated
    public List<KnowledgeSourceParams> getKnowledgeSourceParams() {
        return this.knowledgeSourceParams;
    }

    /**
     * Set the knowledgeSourceParams property: The knowledgeSourceParams property.
     * 
     * @param knowledgeSourceParams the knowledgeSourceParams value to set.
     * @return the KnowledgeAgentRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeAgentRetrievalRequest setKnowledgeSourceParams(List<KnowledgeSourceParams> knowledgeSourceParams) {
        this.knowledgeSourceParams = knowledgeSourceParams;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("knowledgeSourceParams", this.knowledgeSourceParams,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentRetrievalRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentRetrievalRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentRetrievalRequest.
     */
    @Generated
    public static KnowledgeAgentRetrievalRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean messagesFound = false;
            List<KnowledgeAgentMessage> messages = null;
            List<KnowledgeSourceParams> knowledgeSourceParams = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> KnowledgeAgentMessage.fromJson(reader1));
                    messagesFound = true;
                } else if ("knowledgeSourceParams".equals(fieldName)) {
                    knowledgeSourceParams = reader.readArray(reader1 -> KnowledgeSourceParams.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            if (messagesFound) {
                KnowledgeAgentRetrievalRequest deserializedKnowledgeAgentRetrievalRequest
                    = new KnowledgeAgentRetrievalRequest(messages);
                deserializedKnowledgeAgentRetrievalRequest.knowledgeSourceParams = knowledgeSourceParams;

                return deserializedKnowledgeAgentRetrievalRequest;
            }
            throw new IllegalStateException("Missing required property: messages");
        });
    }
}
