// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a retrieval activity record.
 */
@Fluent
public final class KnowledgeAgentSearchActivityRecord extends KnowledgeAgentActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "AzureSearchQuery";

    /*
     * The target index for the retrieval activity.
     */
    @Generated
    private String targetIndex;

    /*
     * The query details for the retrieval activity.
     */
    @Generated
    private KnowledgeAgentSearchActivityRecordQuery query;

    /*
     * The query time for this retrieval activity.
     */
    @Generated
    private OffsetDateTime queryTime;

    /*
     * The count of documents retrieved.
     */
    @Generated
    private Integer count;

    /*
     * The elapsed time in milliseconds for the retrieval activity.
     */
    @Generated
    private Integer elapsedMs;

    /**
     * Creates an instance of KnowledgeAgentSearchActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the targetIndex property: The target index for the retrieval activity.
     * 
     * @return the targetIndex value.
     */
    @Generated
    public String getTargetIndex() {
        return this.targetIndex;
    }

    /**
     * Set the targetIndex property: The target index for the retrieval activity.
     * 
     * @param targetIndex the targetIndex value to set.
     * @return the KnowledgeAgentSearchActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord setTargetIndex(String targetIndex) {
        this.targetIndex = targetIndex;
        return this;
    }

    /**
     * Get the query property: The query details for the retrieval activity.
     * 
     * @return the query value.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecordQuery getQuery() {
        return this.query;
    }

    /**
     * Set the query property: The query details for the retrieval activity.
     * 
     * @param query the query value to set.
     * @return the KnowledgeAgentSearchActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord setQuery(KnowledgeAgentSearchActivityRecordQuery query) {
        this.query = query;
        return this;
    }

    /**
     * Get the queryTime property: The query time for this retrieval activity.
     * 
     * @return the queryTime value.
     */
    @Generated
    public OffsetDateTime getQueryTime() {
        return this.queryTime;
    }

    /**
     * Set the queryTime property: The query time for this retrieval activity.
     * 
     * @param queryTime the queryTime value to set.
     * @return the KnowledgeAgentSearchActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord setQueryTime(OffsetDateTime queryTime) {
        this.queryTime = queryTime;
        return this;
    }

    /**
     * Get the count property: The count of documents retrieved.
     * 
     * @return the count value.
     */
    @Generated
    public Integer getCount() {
        return this.count;
    }

    /**
     * Set the count property: The count of documents retrieved.
     * 
     * @param count the count value to set.
     * @return the KnowledgeAgentSearchActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord setCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @return the elapsedMs value.
     */
    @Generated
    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    /**
     * Set the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @param elapsedMs the elapsedMs value to set.
     * @return the KnowledgeAgentSearchActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("targetIndex", this.targetIndex);
        jsonWriter.writeJsonField("query", this.query);
        jsonWriter.writeStringField("queryTime",
            this.queryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queryTime));
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeNumberField("elapsedMs", this.elapsedMs);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentSearchActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentSearchActivityRecord if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentSearchActivityRecord.
     */
    @Generated
    public static KnowledgeAgentSearchActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = "AzureSearchQuery";
            String targetIndex = null;
            KnowledgeAgentSearchActivityRecordQuery query = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            Integer elapsedMs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("targetIndex".equals(fieldName)) {
                    targetIndex = reader.getString();
                } else if ("query".equals(fieldName)) {
                    query = KnowledgeAgentSearchActivityRecordQuery.fromJson(reader);
                } else if ("queryTime".equals(fieldName)) {
                    queryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeAgentSearchActivityRecord deserializedKnowledgeAgentSearchActivityRecord
                    = new KnowledgeAgentSearchActivityRecord(id);
                deserializedKnowledgeAgentSearchActivityRecord.type = type;
                deserializedKnowledgeAgentSearchActivityRecord.targetIndex = targetIndex;
                deserializedKnowledgeAgentSearchActivityRecord.query = query;
                deserializedKnowledgeAgentSearchActivityRecord.queryTime = queryTime;
                deserializedKnowledgeAgentSearchActivityRecord.count = count;
                deserializedKnowledgeAgentSearchActivityRecord.elapsedMs = elapsedMs;

                return deserializedKnowledgeAgentSearchActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
