// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The query details for the retrieval activity.
 */
@Fluent
public final class KnowledgeAgentSearchActivityRecordQuery
    implements JsonSerializable<KnowledgeAgentSearchActivityRecordQuery> {
    /*
     * The search string.
     */
    @Generated
    private String search;

    /*
     * The filter string.
     */
    @Generated
    private String filter;

    /**
     * Creates an instance of KnowledgeAgentSearchActivityRecordQuery class.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecordQuery() {
    }

    /**
     * Get the search property: The search string.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string.
     * 
     * @param search the search value to set.
     * @return the KnowledgeAgentSearchActivityRecordQuery object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecordQuery setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * Get the filter property: The filter string.
     * 
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The filter string.
     * 
     * @param filter the filter value to set.
     * @return the KnowledgeAgentSearchActivityRecordQuery object itself.
     */
    @Generated
    public KnowledgeAgentSearchActivityRecordQuery setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentSearchActivityRecordQuery from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentSearchActivityRecordQuery if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentSearchActivityRecordQuery.
     */
    @Generated
    public static KnowledgeAgentSearchActivityRecordQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentSearchActivityRecordQuery deserializedKnowledgeAgentSearchActivityRecordQuery
                = new KnowledgeAgentSearchActivityRecordQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeAgentSearchActivityRecordQuery.search = reader.getString();
                } else if ("filter".equals(fieldName)) {
                    deserializedKnowledgeAgentSearchActivityRecordQuery.filter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentSearchActivityRecordQuery;
        });
    }
}
