// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the arguments the search index retrieval activity was run with.
 */
@Fluent
public final class KnowledgeAgentSearchIndexActivityArguments
    implements JsonSerializable<KnowledgeAgentSearchIndexActivityArguments> {
    /*
     * The search string used to query the search index.
     */
    @Generated
    private String search;

    /*
     * The filter string.
     */
    @Generated
    private String filter;

    /**
     * Creates an instance of KnowledgeAgentSearchIndexActivityArguments class.
     */
    @Generated
    public KnowledgeAgentSearchIndexActivityArguments() {
    }

    /**
     * Get the search property: The search string used to query the search index.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string used to query the search index.
     * 
     * @param search the search value to set.
     * @return the KnowledgeAgentSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeAgentSearchIndexActivityArguments setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * Get the filter property: The filter string.
     * 
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The filter string.
     * 
     * @param filter the filter value to set.
     * @return the KnowledgeAgentSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeAgentSearchIndexActivityArguments setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentSearchIndexActivityArguments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentSearchIndexActivityArguments if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentSearchIndexActivityArguments.
     */
    @Generated
    public static KnowledgeAgentSearchIndexActivityArguments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentSearchIndexActivityArguments deserializedKnowledgeAgentSearchIndexActivityArguments
                = new KnowledgeAgentSearchIndexActivityArguments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeAgentSearchIndexActivityArguments.search = reader.getString();
                } else if ("filter".equals(fieldName)) {
                    deserializedKnowledgeAgentSearchIndexActivityArguments.filter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentSearchIndexActivityArguments;
        });
    }
}
