// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a semantic ranker activity record.
 */
@Fluent
public final class KnowledgeAgentSemanticRerankerActivityRecord extends KnowledgeAgentActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "semanticReranker";

    /*
     * The number of input tokens for the semantic ranker activity.
     */
    @Generated
    private Integer inputTokens;

    /**
     * Creates an instance of KnowledgeAgentSemanticRerankerActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeAgentSemanticRerankerActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the inputTokens property: The number of input tokens for the semantic ranker activity.
     * 
     * @return the inputTokens value.
     */
    @Generated
    public Integer getInputTokens() {
        return this.inputTokens;
    }

    /**
     * Set the inputTokens property: The number of input tokens for the semantic ranker activity.
     * 
     * @param inputTokens the inputTokens value to set.
     * @return the KnowledgeAgentSemanticRerankerActivityRecord object itself.
     */
    @Generated
    public KnowledgeAgentSemanticRerankerActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeAgentSemanticRerankerActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", this.inputTokens);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentSemanticRerankerActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentSemanticRerankerActivityRecord if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgentSemanticRerankerActivityRecord.
     */
    @Generated
    public static KnowledgeAgentSemanticRerankerActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "semanticReranker";
            Integer inputTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("inputTokens".equals(fieldName)) {
                    inputTokens = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeAgentSemanticRerankerActivityRecord deserializedKnowledgeAgentSemanticRerankerActivityRecord
                    = new KnowledgeAgentSemanticRerankerActivityRecord(id);
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.type = type;
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.inputTokens = inputTokens;

                return deserializedKnowledgeAgentSemanticRerankerActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
