// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The kind of the knowledge source.
 */
public final class KnowledgeSourceKind extends ExpandableStringEnum<KnowledgeSourceKind> {
    /**
     * A knowledge source that reads data from a Search Index.
     */
    @Generated
    public static final KnowledgeSourceKind SEARCH_INDEX = fromString("searchIndex");

    /**
     * A knowledge source that read and ingest data from Azure Blob Storage to a Search Index.
     */
    @Generated
    public static final KnowledgeSourceKind AZURE_BLOB = fromString("azureBlob");

    /**
     * Creates a new instance of KnowledgeSourceKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public KnowledgeSourceKind() {
    }

    /**
     * Creates or finds a KnowledgeSourceKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KnowledgeSourceKind.
     */
    @Generated
    public static KnowledgeSourceKind fromString(String name) {
        return fromString(name, KnowledgeSourceKind.class);
    }

    /**
     * Gets known KnowledgeSourceKind values.
     * 
     * @return known KnowledgeSourceKind values.
     */
    @Generated
    public static Collection<KnowledgeSourceKind> values() {
        return values(KnowledgeSourceKind.class);
    }
}
