// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.agents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies runtime parameters for a search index knowledge source.
 */
@Fluent
public final class SearchIndexKnowledgeSourceParams extends KnowledgeSourceParams {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;

    /*
     * A filter condition applied to the index (e.g., 'State eq VA').
     */
    @Generated
    private String filterAddOn;

    /**
     * Creates an instance of SearchIndexKnowledgeSourceParams class.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     */
    @Generated
    public SearchIndexKnowledgeSourceParams(String knowledgeSourceName) {
        super(knowledgeSourceName);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the filterAddOn property: A filter condition applied to the index (e.g., 'State eq VA').
     * 
     * @return the filterAddOn value.
     */
    @Generated
    public String getFilterAddOn() {
        return this.filterAddOn;
    }

    /**
     * Set the filterAddOn property: A filter condition applied to the index (e.g., 'State eq VA').
     * 
     * @param filterAddOn the filterAddOn value to set.
     * @return the SearchIndexKnowledgeSourceParams object itself.
     */
    @Generated
    public SearchIndexKnowledgeSourceParams setFilterAddOn(String filterAddOn) {
        this.filterAddOn = filterAddOn;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("filterAddOn", this.filterAddOn);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexKnowledgeSourceParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexKnowledgeSourceParams if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexKnowledgeSourceParams.
     */
    @Generated
    public static SearchIndexKnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
            String filterAddOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("filterAddOn".equals(fieldName)) {
                    filterAddOn = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourceNameFound) {
                SearchIndexKnowledgeSourceParams deserializedSearchIndexKnowledgeSourceParams
                    = new SearchIndexKnowledgeSourceParams(knowledgeSourceName);
                deserializedSearchIndexKnowledgeSourceParams.kind = kind;
                deserializedSearchIndexKnowledgeSourceParams.filterAddOn = filterAddOn;

                return deserializedSearchIndexKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}
