// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.search.documents.models.QueryDebugMode;
import com.azure.search.documents.models.QueryLanguage;
import com.azure.search.documents.models.QuerySpellerType;
import com.azure.search.documents.models.QueryType;
import com.azure.search.documents.models.ScoringStatistics;
import com.azure.search.documents.models.SearchMode;
import com.azure.search.documents.models.SemanticErrorMode;
import java.util.Arrays;
import java.util.List;

/**
 * Parameter group.
 */
@Fluent
public final class SearchOptions {

    /*
     * A value that specifies whether to fetch the total count of results. Default is false. Setting this value to true
     * may have a performance impact. Note that the count returned is an approximation.
     */
    @Generated
    private Boolean includeTotalCount;

    /*
     * The list of facet expressions to apply to the search query. Each facet expression contains a field name,
     * optionally followed by a comma-separated list of name:value pairs.
     */
    @Generated
    private List<String> facets;

    /*
     * The OData $filter expression to apply to the search query.
     */
    @Generated
    private String filter;

    /*
     * The list of field names to use for hit highlights. Only searchable fields can be used for hit highlighting.
     */
    @Generated
    private List<String> highlightFields;

    /*
     * A string tag that is appended to hit highlights. Must be set with highlightPreTag. Default is &lt;/em&gt;.
     */
    @Generated
    private String highlightPostTag;

    /*
     * A string tag that is prepended to hit highlights. Must be set with highlightPostTag. Default is &lt;em&gt;.
     */
    @Generated
    private String highlightPreTag;

    /*
     * A number between 0 and 100 indicating the percentage of the index that must be covered by a search query in order
     * for the query to be reported as a success. This parameter can be useful for ensuring search availability even for
     * services with only one replica. The default is 100.
     */
    @Generated
    private Double minimumCoverage;

    /*
     * The list of OData $orderby expressions by which to sort the results. Each expression can be either a field name
     * or a call to either the geo.distance() or the search.score() functions. Each expression can be followed by asc to
     * indicate ascending, and desc to indicate descending. The default is ascending order. Ties will be broken by the
     * match scores of documents. If no OrderBy is specified, the default sort order is descending by document match
     * score. There can be at most 32 $orderby clauses.
     */
    @Generated
    private List<String> orderBy;

    /*
     * A value that specifies the syntax of the search query. The default is 'simple'. Use 'full' if your query uses the
     * Lucene query syntax.
     */
    @Generated
    private QueryType queryType;

    /*
     * The list of parameter values to be used in scoring functions (for example, referencePointParameter) using the
     * format name-values. For example, if the scoring profile defines a function with a parameter called 'mylocation'
     * the parameter string would be "mylocation--122.2,44.8" (without the quotes).
     */
    @Generated
    private List<String> scoringParameters;

    /*
     * The name of a scoring profile to evaluate match scores for matching documents in order to sort the results.
     */
    @Generated
    private String scoringProfile;

    /*
     * The list of field names to which to scope the full-text search. When using fielded search
     * (fieldName:searchExpression) in a full Lucene query, the field names of each fielded search expression take
     * precedence over any field names listed in this parameter.
     */
    @Generated
    private List<String> searchFields;

    /*
     * A value that specifies whether any or all of the search terms must be matched in order to count the document as a
     * match.
     */
    @Generated
    private SearchMode searchMode;

    /*
     * A value that specifies whether we want to calculate scoring statistics (such as document frequency) globally for
     * more consistent scoring, or locally, for lower latency.
     */
    @Generated
    private ScoringStatistics scoringStatistics;

    /*
     * A value to be used to create a sticky session, which can help to get more consistent results. As long as the same
     * sessionId is used, a best-effort attempt will be made to target the same replica set. Be wary that reusing the
     * same sessionID values repeatedly can interfere with the load balancing of the requests across replicas and
     * adversely affect the performance of the search service. The value used as sessionId cannot start with a '_'
     * character.
     */
    @Generated
    private String sessionId;

    /*
     * The list of fields to retrieve. If unspecified, all fields marked as retrievable in the schema are included.
     */
    @Generated
    private List<String> select;

    /*
     * The number of search results to skip. This value cannot be greater than 100,000. If you need to scan documents in
     * sequence, but cannot use $skip due to this limitation, consider using $orderby on a totally-ordered key and
     * $filter with a range query instead.
     */
    @Generated
    private Integer skip;

    /*
     * The number of search results to retrieve. This can be used in conjunction with $skip to implement client-side
     * paging of search results. If results are truncated due to server-side paging, the response will include a
     * continuation token that can be used to issue another Search request for the next page of results.
     */
    @Generated
    private Integer top;

    /*
     * The name of the semantic configuration that lists which fields should be used for semantic ranking, captions,
     * highlights, and answers
     */
    @Generated
    private String semanticConfiguration;

    /*
     * Allows the user to choose whether a semantic call should fail completely, or to return partial results (default).
     */
    @Generated
    private SemanticErrorMode semanticErrorHandling;

    /*
     * Allows the user to set an upper bound on the amount of time it takes for semantic enrichment to finish processing
     * before the request fails.
     */
    @Generated
    private Integer semanticMaxWaitInMilliseconds;

    /*
     * This parameter is only valid if the query type is `semantic`. If set, the query returns answers extracted from
     * key passages in the highest ranked documents. The number of answers returned can be configured by appending the
     * pipe character `|` followed by the `count-<number of answers>` option after the answers parameter value, such as
     * `extractive|count-3`. Default count is 1. The confidence threshold can be configured by appending the pipe
     * character `|` followed by the `threshold-<confidence threshold>` option after the answers parameter value, such
     * as `extractive|threshold-0.9`. Default threshold is 0.7. The maximum character length of answers can be
     * configured by appending the pipe character '|' followed by the 'count-<number of maximum character length>', such
     * as 'extractive|maxcharlength-600'.
     */
    @Generated
    private String answers;

    /*
     * This parameter is only valid if the query type is `semantic`. If set, the query returns captions extracted from
     * key passages in the highest ranked documents. When Captions is set to `extractive`, highlighting is enabled by
     * default, and can be configured by appending the pipe character `|` followed by the `highlight-<true/false>`
     * option, such as `extractive|highlight-true`. Defaults to `None`. The maximum character length of captions can be
     * configured by appending the pipe character '|' followed by the 'count-<number of maximum character length>', such
     * as 'extractive|maxcharlength-600'.
     */
    @Generated
    private String captions;

    /*
     * Allows setting a separate search query that will be solely used for semantic reranking, semantic captions and
     * semantic answers. Is useful for scenarios where there is a need to use different queries between the base
     * retrieval and ranking phase, and the L2 semantic phase.
     */
    @Generated
    private String semanticQuery;

    /*
     * When QueryRewrites is set to `generative`, the query terms are sent to a generate model which will produce 10
     * (default) rewrites to help increase the recall of the request. The requested count can be configured by appending
     * the pipe character `|` followed by the `count-<number of rewrites>` option, such as `generative|count-3`.
     * Defaults to `None`. This parameter is only valid if the query type is `semantic`.
     */
    @Generated
    private String queryRewrites;

    /*
     * Enables a debugging tool that can be used to further explore your search results.
     */
    @Generated
    private QueryDebugMode debug;

    /*
     * The language of the query.
     */
    @Generated
    private QueryLanguage queryLanguage;

    /*
     * Improve search recall by spell-correcting individual search query terms.
     */
    @Generated
    private QuerySpellerType speller;

    /*
     * The list of field names used for semantic ranking.
     */
    @Generated
    private List<String> semanticFields;

    /**
     * Creates an instance of SearchOptions class.
     */
    @Generated
    public SearchOptions() {
    }

    /**
     * Get the includeTotalCount property: A value that specifies whether to fetch the total count of results. Default
     * is false. Setting this value to true may have a performance impact. Note that the count returned is an
     * approximation.
     *
     * @return the includeTotalCount value.
     */
    @Generated
    public Boolean isTotalCountIncluded() {
        return this.includeTotalCount;
    }

    /**
     * Set the includeTotalCount property: A value that specifies whether to fetch the total count of results. Default
     * is false. Setting this value to true may have a performance impact. Note that the count returned is an
     * approximation.
     *
     * @param includeTotalCount the includeTotalCount value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setIncludeTotalCount(Boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    /**
     * Get the facets property: The list of facet expressions to apply to the search query. Each facet expression
     * contains a field name, optionally followed by a comma-separated list of name:value pairs.
     *
     * @return the facets value.
     */
    @Generated
    public List<String> getFacets() {
        return this.facets;
    }

    /**
     * Set the facets property: The list of facet expressions to apply to the search query. Each facet expression
     * contains a field name, optionally followed by a comma-separated list of name:value pairs.
     *
     * @param facets the facets value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setFacets(List<String> facets) {
        this.facets = facets;
        return this;
    }

    /**
     * Get the filter property: The OData $filter expression to apply to the search query.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The OData $filter expression to apply to the search query.
     *
     * @param filter the filter value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the highlightFields property: The list of field names to use for hit highlights. Only searchable fields can
     * be used for hit highlighting.
     *
     * @return the highlightFields value.
     */
    @Generated
    public List<String> getHighlightFields() {
        return this.highlightFields;
    }

    /**
     * Set the highlightFields property: The list of field names to use for hit highlights. Only searchable fields can
     * be used for hit highlighting.
     *
     * @param highlightFields the highlightFields value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setHighlightFields(List<String> highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    /**
     * Get the highlightPostTag property: A string tag that is appended to hit highlights. Must be set with
     * highlightPreTag. Default is &amp;lt;/em&amp;gt;.
     *
     * @return the highlightPostTag value.
     */
    @Generated
    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    /**
     * Set the highlightPostTag property: A string tag that is appended to hit highlights. Must be set with
     * highlightPreTag. Default is &amp;lt;/em&amp;gt;.
     *
     * @param highlightPostTag the highlightPostTag value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    /**
     * Get the highlightPreTag property: A string tag that is prepended to hit highlights. Must be set with
     * highlightPostTag. Default is &amp;lt;em&amp;gt;.
     *
     * @return the highlightPreTag value.
     */
    @Generated
    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    /**
     * Set the highlightPreTag property: A string tag that is prepended to hit highlights. Must be set with
     * highlightPostTag. Default is &amp;lt;em&amp;gt;.
     *
     * @param highlightPreTag the highlightPreTag value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    /**
     * Get the minimumCoverage property: A number between 0 and 100 indicating the percentage of the index that must be
     * covered by a search query in order for the query to be reported as a success. This parameter can be useful for
     * ensuring search availability even for services with only one replica. The default is 100.
     *
     * @return the minimumCoverage value.
     */
    @Generated
    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    /**
     * Set the minimumCoverage property: A number between 0 and 100 indicating the percentage of the index that must be
     * covered by a search query in order for the query to be reported as a success. This parameter can be useful for
     * ensuring search availability even for services with only one replica. The default is 100.
     *
     * @param minimumCoverage the minimumCoverage value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    /**
     * Get the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, and desc to indicate descending. The default is
     * ascending order. Ties will be broken by the match scores of documents. If no OrderBy is specified, the default
     * sort order is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @return the orderBy value.
     */
    @Generated
    public List<String> getOrderBy() {
        return this.orderBy;
    }

    /**
     * Set the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, and desc to indicate descending. The default is
     * ascending order. Ties will be broken by the match scores of documents. If no OrderBy is specified, the default
     * sort order is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @param orderBy the orderBy value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setOrderBy(List<String> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    /**
     * Get the queryType property: A value that specifies the syntax of the search query. The default is 'simple'. Use
     * 'full' if your query uses the Lucene query syntax.
     *
     * @return the queryType value.
     */
    @Generated
    public QueryType getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: A value that specifies the syntax of the search query. The default is 'simple'. Use
     * 'full' if your query uses the Lucene query syntax.
     *
     * @param queryType the queryType value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setQueryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the scoringParameters property: The list of parameter values to be used in scoring functions (for example,
     * referencePointParameter) using the format name-values. For example, if the scoring profile defines a function
     * with a parameter called 'mylocation' the parameter string would be "mylocation--122.2,44.8" (without the quotes).
     *
     * @return the scoringParameters value.
     */
    @Generated
    public List<String> getScoringParameters() {
        return this.scoringParameters;
    }

    /**
     * Set the scoringParameters property: The list of parameter values to be used in scoring functions (for example,
     * referencePointParameter) using the format name-values. For example, if the scoring profile defines a function
     * with a parameter called 'mylocation' the parameter string would be "mylocation--122.2,44.8" (without the quotes).
     *
     * @param scoringParameters the scoringParameters value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setScoringParameters(List<String> scoringParameters) {
        this.scoringParameters = scoringParameters;
        return this;
    }

    /**
     * Get the scoringProfile property: The name of a scoring profile to evaluate match scores for matching documents in
     * order to sort the results.
     *
     * @return the scoringProfile value.
     */
    @Generated
    public String getScoringProfile() {
        return this.scoringProfile;
    }

    /**
     * Set the scoringProfile property: The name of a scoring profile to evaluate match scores for matching documents in
     * order to sort the results.
     *
     * @param scoringProfile the scoringProfile value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setScoringProfile(String scoringProfile) {
        this.scoringProfile = scoringProfile;
        return this;
    }

    /**
     * Get the searchFields property: The list of field names to which to scope the full-text search. When using fielded
     * search (fieldName:searchExpression) in a full Lucene query, the field names of each fielded search expression
     * take precedence over any field names listed in this parameter.
     *
     * @return the searchFields value.
     */
    @Generated
    public List<String> getSearchFields() {
        return this.searchFields;
    }

    /**
     * Set the searchFields property: The list of field names to which to scope the full-text search. When using fielded
     * search (fieldName:searchExpression) in a full Lucene query, the field names of each fielded search expression
     * take precedence over any field names listed in this parameter.
     *
     * @param searchFields the searchFields value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    /**
     * Get the searchMode property: A value that specifies whether any or all of the search terms must be matched in
     * order to count the document as a match.
     *
     * @return the searchMode value.
     */
    @Generated
    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    /**
     * Set the searchMode property: A value that specifies whether any or all of the search terms must be matched in
     * order to count the document as a match.
     *
     * @param searchMode the searchMode value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
        return this;
    }

    /**
     * Get the scoringStatistics property: A value that specifies whether we want to calculate scoring statistics (such
     * as document frequency) globally for more consistent scoring, or locally, for lower latency.
     *
     * @return the scoringStatistics value.
     */
    @Generated
    public ScoringStatistics getScoringStatistics() {
        return this.scoringStatistics;
    }

    /**
     * Set the scoringStatistics property: A value that specifies whether we want to calculate scoring statistics (such
     * as document frequency) globally for more consistent scoring, or locally, for lower latency.
     *
     * @param scoringStatistics the scoringStatistics value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setScoringStatistics(ScoringStatistics scoringStatistics) {
        this.scoringStatistics = scoringStatistics;
        return this;
    }

    /**
     * Get the sessionId property: A value to be used to create a sticky session, which can help to get more consistent
     * results. As long as the same sessionId is used, a best-effort attempt will be made to target the same replica
     * set. Be wary that reusing the same sessionID values repeatedly can interfere with the load balancing of the
     * requests across replicas and adversely affect the performance of the search service. The value used as sessionId
     * cannot start with a '_' character.
     *
     * @return the sessionId value.
     */
    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * Set the sessionId property: A value to be used to create a sticky session, which can help to get more consistent
     * results. As long as the same sessionId is used, a best-effort attempt will be made to target the same replica
     * set. Be wary that reusing the same sessionID values repeatedly can interfere with the load balancing of the
     * requests across replicas and adversely affect the performance of the search service. The value used as sessionId
     * cannot start with a '_' character.
     *
     * @param sessionId the sessionId value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    /**
     * Get the select property: The list of fields to retrieve. If unspecified, all fields marked as retrievable in the
     * schema are included.
     *
     * @return the select value.
     */
    @Generated
    public List<String> getSelect() {
        return this.select;
    }

    /**
     * Set the select property: The list of fields to retrieve. If unspecified, all fields marked as retrievable in the
     * schema are included.
     *
     * @param select the select value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSelect(List<String> select) {
        this.select = select;
        return this;
    }

    /**
     * Get the skip property: The number of search results to skip. This value cannot be greater than 100,000. If you
     * need to scan documents in sequence, but cannot use $skip due to this limitation, consider using $orderby on a
     * totally-ordered key and $filter with a range query instead.
     *
     * @return the skip value.
     */
    @Generated
    public Integer getSkip() {
        return this.skip;
    }

    /**
     * Set the skip property: The number of search results to skip. This value cannot be greater than 100,000. If you
     * need to scan documents in sequence, but cannot use $skip due to this limitation, consider using $orderby on a
     * totally-ordered key and $filter with a range query instead.
     *
     * @param skip the skip value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    /**
     * Get the top property: The number of search results to retrieve. This can be used in conjunction with $skip to
     * implement client-side paging of search results. If results are truncated due to server-side paging, the response
     * will include a continuation token that can be used to issue another Search request for the next page of results.
     *
     * @return the top value.
     */
    @Generated
    public Integer getTop() {
        return this.top;
    }

    /**
     * Set the top property: The number of search results to retrieve. This can be used in conjunction with $skip to
     * implement client-side paging of search results. If results are truncated due to server-side paging, the response
     * will include a continuation token that can be used to issue another Search request for the next page of results.
     *
     * @param top the top value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setTop(Integer top) {
        this.top = top;
        return this;
    }

    /**
     * Get the semanticConfiguration property: The name of the semantic configuration that lists which fields should be
     * used for semantic ranking, captions, highlights, and answers.
     *
     * @return the semanticConfiguration value.
     */
    @Generated
    public String getSemanticConfiguration() {
        return this.semanticConfiguration;
    }

    /**
     * Set the semanticConfiguration property: The name of the semantic configuration that lists which fields should be
     * used for semantic ranking, captions, highlights, and answers.
     *
     * @param semanticConfiguration the semanticConfiguration value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSemanticConfiguration(String semanticConfiguration) {
        this.semanticConfiguration = semanticConfiguration;
        return this;
    }

    /**
     * Get the semanticErrorHandling property: Allows the user to choose whether a semantic call should fail completely,
     * or to return partial results (default).
     *
     * @return the semanticErrorHandling value.
     */
    @Generated
    public SemanticErrorMode getSemanticErrorHandling() {
        return this.semanticErrorHandling;
    }

    /**
     * Set the semanticErrorHandling property: Allows the user to choose whether a semantic call should fail completely,
     * or to return partial results (default).
     *
     * @param semanticErrorHandling the semanticErrorHandling value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSemanticErrorHandling(SemanticErrorMode semanticErrorHandling) {
        this.semanticErrorHandling = semanticErrorHandling;
        return this;
    }

    /**
     * Get the semanticMaxWaitInMilliseconds property: Allows the user to set an upper bound on the amount of time it
     * takes for semantic enrichment to finish processing before the request fails.
     *
     * @return the semanticMaxWaitInMilliseconds value.
     */
    @Generated
    public Integer getSemanticMaxWaitInMilliseconds() {
        return this.semanticMaxWaitInMilliseconds;
    }

    /**
     * Set the semanticMaxWaitInMilliseconds property: Allows the user to set an upper bound on the amount of time it
     * takes for semantic enrichment to finish processing before the request fails.
     *
     * @param semanticMaxWaitInMilliseconds the semanticMaxWaitInMilliseconds value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSemanticMaxWaitInMilliseconds(Integer semanticMaxWaitInMilliseconds) {
        this.semanticMaxWaitInMilliseconds = semanticMaxWaitInMilliseconds;
        return this;
    }

    /**
     * Get the answers property: This parameter is only valid if the query type is `semantic`. If set, the query returns
     * answers extracted from key passages in the highest ranked documents. The number of answers returned can be
     * configured by appending the pipe character `|` followed by the `count-&lt;number of answers&gt;` option after the
     * answers parameter value, such as `extractive|count-3`. Default count is 1. The confidence threshold can be
     * configured by appending the pipe character `|` followed by the `threshold-&lt;confidence threshold&gt;` option
     * after the answers parameter value, such as `extractive|threshold-0.9`. Default threshold is 0.7. The maximum
     * character length of answers can be configured by appending the pipe character '|' followed by the
     * 'count-&lt;number of maximum character length&gt;', such as 'extractive|maxcharlength-600'.
     *
     * @return the answers value.
     */
    @Generated
    public String getAnswers() {
        return this.answers;
    }

    /**
     * Set the answers property: This parameter is only valid if the query type is `semantic`. If set, the query returns
     * answers extracted from key passages in the highest ranked documents. The number of answers returned can be
     * configured by appending the pipe character `|` followed by the `count-&lt;number of answers&gt;` option after the
     * answers parameter value, such as `extractive|count-3`. Default count is 1. The confidence threshold can be
     * configured by appending the pipe character `|` followed by the `threshold-&lt;confidence threshold&gt;` option
     * after the answers parameter value, such as `extractive|threshold-0.9`. Default threshold is 0.7. The maximum
     * character length of answers can be configured by appending the pipe character '|' followed by the
     * 'count-&lt;number of maximum character length&gt;', such as 'extractive|maxcharlength-600'.
     *
     * @param answers the answers value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setAnswers(String answers) {
        this.answers = answers;
        return this;
    }

    /**
     * Get the captions property: This parameter is only valid if the query type is `semantic`. If set, the query
     * returns captions extracted from key passages in the highest ranked documents. When Captions is set to
     * `extractive`, highlighting is enabled by default, and can be configured by appending the pipe character `|`
     * followed by the `highlight-&lt;true/false&gt;` option, such as `extractive|highlight-true`. Defaults to `None`.
     * The maximum character length of captions can be configured by appending the pipe character '|' followed by the
     * 'count-&lt;number of maximum character length&gt;', such as 'extractive|maxcharlength-600'.
     *
     * @return the captions value.
     */
    @Generated
    public String getCaptions() {
        return this.captions;
    }

    /**
     * Set the captions property: This parameter is only valid if the query type is `semantic`. If set, the query
     * returns captions extracted from key passages in the highest ranked documents. When Captions is set to
     * `extractive`, highlighting is enabled by default, and can be configured by appending the pipe character `|`
     * followed by the `highlight-&lt;true/false&gt;` option, such as `extractive|highlight-true`. Defaults to `None`.
     * The maximum character length of captions can be configured by appending the pipe character '|' followed by the
     * 'count-&lt;number of maximum character length&gt;', such as 'extractive|maxcharlength-600'.
     *
     * @param captions the captions value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setCaptions(String captions) {
        this.captions = captions;
        return this;
    }

    /**
     * Get the semanticQuery property: Allows setting a separate search query that will be solely used for semantic
     * reranking, semantic captions and semantic answers. Is useful for scenarios where there is a need to use different
     * queries between the base retrieval and ranking phase, and the L2 semantic phase.
     *
     * @return the semanticQuery value.
     */
    @Generated
    public String getSemanticQuery() {
        return this.semanticQuery;
    }

    /**
     * Set the semanticQuery property: Allows setting a separate search query that will be solely used for semantic
     * reranking, semantic captions and semantic answers. Is useful for scenarios where there is a need to use different
     * queries between the base retrieval and ranking phase, and the L2 semantic phase.
     *
     * @param semanticQuery the semanticQuery value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSemanticQuery(String semanticQuery) {
        this.semanticQuery = semanticQuery;
        return this;
    }

    /**
     * Get the queryRewrites property: When QueryRewrites is set to `generative`, the query terms are sent to a generate
     * model which will produce 10 (default) rewrites to help increase the recall of the request. The requested count
     * can be configured by appending the pipe character `|` followed by the `count-&lt;number of rewrites&gt;` option,
     * such as `generative|count-3`. Defaults to `None`. This parameter is only valid if the query type is `semantic`.
     *
     * @return the queryRewrites value.
     */
    @Generated
    public String getQueryRewrites() {
        return this.queryRewrites;
    }

    /**
     * Set the queryRewrites property: When QueryRewrites is set to `generative`, the query terms are sent to a generate
     * model which will produce 10 (default) rewrites to help increase the recall of the request. The requested count
     * can be configured by appending the pipe character `|` followed by the `count-&lt;number of rewrites&gt;` option,
     * such as `generative|count-3`. Defaults to `None`. This parameter is only valid if the query type is `semantic`.
     *
     * @param queryRewrites the queryRewrites value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setQueryRewrites(String queryRewrites) {
        this.queryRewrites = queryRewrites;
        return this;
    }

    /**
     * Get the debug property: Enables a debugging tool that can be used to further explore your search results.
     *
     * @return the debug value.
     */
    @Generated
    public QueryDebugMode getDebug() {
        return this.debug;
    }

    /**
     * Set the debug property: Enables a debugging tool that can be used to further explore your search results.
     *
     * @param debug the debug value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setDebug(QueryDebugMode debug) {
        this.debug = debug;
        return this;
    }

    /**
     * Get the queryLanguage property: The language of the query.
     *
     * @return the queryLanguage value.
     */
    @Generated
    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    /**
     * Set the queryLanguage property: The language of the query.
     *
     * @param queryLanguage the queryLanguage value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setQueryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
        return this;
    }

    /**
     * Get the speller property: Improve search recall by spell-correcting individual search query terms.
     *
     * @return the speller value.
     */
    @Generated
    public QuerySpellerType getSpeller() {
        return this.speller;
    }

    /**
     * Set the speller property: Improve search recall by spell-correcting individual search query terms.
     *
     * @param speller the speller value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSpeller(QuerySpellerType speller) {
        this.speller = speller;
        return this;
    }

    /**
     * Get the semanticFields property: The list of field names used for semantic ranking.
     *
     * @return the semanticFields value.
     */
    @Generated
    public List<String> getSemanticFields() {
        return this.semanticFields;
    }

    /**
     * Set the semanticFields property: The list of field names used for semantic ranking.
     *
     * @param semanticFields the semanticFields value to set.
     * @return the SearchOptions object itself.
     */
    @Generated
    public SearchOptions setSemanticFields(List<String> semanticFields) {
        this.semanticFields = semanticFields;
        return this;
    }

    /**
     * Set the facets property: The list of facet expressions to apply to the search query. Each facet expression
     * contains a field name, optionally followed by a comma-separated list of name:value pairs.
     *
     * @param facets the facets value to set.
     * @return the SearchOptions object itself.
     */
    public SearchOptions setFacets(String... facets) {
        this.facets = (facets == null) ? null : Arrays.asList(facets);
        return this;
    }

    /**
     * Set the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, and desc to indicate descending. The default is
     * ascending order. Ties will be broken by the match scores of documents. If no OrderBy is specified, the default
     * sort order is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @param orderBy the orderBy value to set.
     * @return the SearchOptions object itself.
     */
    public SearchOptions setOrderBy(String... orderBy) {
        this.orderBy = (orderBy == null) ? null : Arrays.asList(orderBy);
        return this;
    }

    /**
     * Set the searchFields property: The list of field names to which to scope the full-text search. When using fielded
     * search (fieldName:searchExpression) in a full Lucene query, the field names of each fielded search expression
     * take precedence over any field names listed in this parameter.
     *
     * @param searchFields the searchFields value to set.
     * @return the SearchOptions object itself.
     */
    public SearchOptions setSearchFields(String... searchFields) {
        this.searchFields = (searchFields == null) ? null : Arrays.asList(searchFields);
        return this;
    }

    /**
     * Set the select property: The list of fields to retrieve. If unspecified, all fields marked as retrievable in the
     * schema are included.
     *
     * @param select the select value to set.
     * @return the SearchOptions object itself.
     */
    public SearchOptions setSelect(String... select) {
        this.select = (select == null) ? null : Arrays.asList(select);
        return this;
    }

    /**
     * Set the highlightFields property: The list of field names to use for hit highlights. Only searchable fields can
     * be used for hit highlighting.
     *
     * @param highlightFields the highlightFields value to set.
     * @return the SearchOptions object itself.
     */
    public SearchOptions setHighlightFields(String... highlightFields) {
        this.highlightFields = (highlightFields == null) ? null : Arrays.asList(highlightFields);
        return this;
    }
}
