// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListAliasesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.SearchAlias;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Aliases.
 */
public final class AliasesImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AliasesService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchServiceClientImpl client;

    /**
     * Initializes an instance of AliasesImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AliasesImpl(SearchServiceClientImpl client) {
        this.service = RestProxy.create(AliasesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchServiceClientAliases to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClientAliases")
    public interface AliasesService {
        @Post("/aliases")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchAlias>> create(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") SearchAlias alias, Context context);

        @Post("/aliases")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchAlias> createSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") SearchAlias alias, Context context);

        @Get("/aliases")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ListAliasesResult>> list(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/aliases")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ListAliasesResult> listSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Put("/aliases('{aliasName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchAlias>> createOrUpdate(@HostParam("endpoint") String endpoint,
            @PathParam("aliasName") String aliasName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") SearchAlias alias, Context context);

        @Put("/aliases('{aliasName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchAlias> createOrUpdateSync(@HostParam("endpoint") String endpoint,
            @PathParam("aliasName") String aliasName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") SearchAlias alias, Context context);

        @Delete("/aliases('{aliasName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> delete(@HostParam("endpoint") String endpoint, @PathParam("aliasName") String aliasName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/aliases('{aliasName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteSync(@HostParam("endpoint") String endpoint, @PathParam("aliasName") String aliasName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/aliases('{aliasName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchAlias>> get(@HostParam("endpoint") String endpoint,
            @PathParam("aliasName") String aliasName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/aliases('{aliasName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchAlias> getSync(@HostParam("endpoint") String endpoint, @PathParam("aliasName") String aliasName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createWithResponseAsync(SearchAlias alias, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createWithResponseAsync(alias, requestOptions, context));
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createWithResponseAsync(SearchAlias alias, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, alias,
            context);
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> createAsync(SearchAlias alias, RequestOptions requestOptions) {
        return createWithResponseAsync(alias, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> createAsync(SearchAlias alias, RequestOptions requestOptions, Context context) {
        return createWithResponseAsync(alias, requestOptions, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchAlias> createWithResponse(SearchAlias alias, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            alias, context);
    }

    /**
     * Creates a new search alias.
     * 
     * @param alias The definition of the alias to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchAlias create(SearchAlias alias, RequestOptions requestOptions) {
        return createWithResponse(alias, requestOptions, Context.NONE).getValue();
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SearchAlias>> listSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), xMsClientRequestId,
                this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAliases(), null, null));
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SearchAlias>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAliases(), null, null));
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchAlias> listAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions));
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SearchAlias> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions, context));
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SearchAlias> listSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListAliasesResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getAliases(), null, null);
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SearchAlias> listSinglePage(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListAliasesResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getAliases(), null, null);
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchAlias> list(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions));
    }

    /**
     * Lists all aliases available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Aliases request as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SearchAlias> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions, context));
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createOrUpdateWithResponseAsync(String aliasName, SearchAlias alias,
        String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch,
            requestOptions, context));
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> createOrUpdateWithResponseAsync(String aliasName, SearchAlias alias,
        String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdate(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch,
            prefer, this.client.getApiVersion(), accept, alias, context);
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> createOrUpdateAsync(String aliasName, SearchAlias alias, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions) {
        return createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> createOrUpdateAsync(String aliasName, SearchAlias alias, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return createOrUpdateWithResponseAsync(aliasName, alias, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchAlias> createOrUpdateWithResponse(String aliasName, SearchAlias alias, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdateSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch,
            ifNoneMatch, prefer, this.client.getApiVersion(), accept, alias, context);
    }

    /**
     * Creates a new search alias or updates an alias if it already exists.
     * 
     * @param aliasName The definition of the alias to create or update.
     * @param alias The definition of the alias to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchAlias createOrUpdate(String aliasName, SearchAlias alias, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return createOrUpdateWithResponse(aliasName, alias, ifMatch, ifNoneMatch, requestOptions, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String aliasName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return FluxUtil
            .withContext(context -> deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions, context));
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String aliasName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.delete(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        return deleteWithResponseAsync(aliasName, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String aliasName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.deleteSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a search alias and its associated mapping to an index. This operation is permanent, with no recovery
     * option. The mapped index is untouched by this operation.
     * 
     * @param aliasName The name of the alias to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String aliasName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        deleteWithResponse(aliasName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> getWithResponseAsync(String aliasName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getWithResponseAsync(aliasName, requestOptions, context));
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchAlias>> getWithResponseAsync(String aliasName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.get(this.client.getEndpoint(), aliasName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> getAsync(String aliasName, RequestOptions requestOptions) {
        return getWithResponseAsync(aliasName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchAlias> getAsync(String aliasName, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(aliasName, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchAlias> getWithResponse(String aliasName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getSync(this.client.getEndpoint(), aliasName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an alias definition.
     * 
     * @param aliasName The name of the alias to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an index alias, which describes a mapping from the alias name to an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchAlias get(String aliasName, RequestOptions requestOptions) {
        return getWithResponse(aliasName, requestOptions, Context.NONE).getValue();
    }
}
