// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListKnowledgeAgentsResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.KnowledgeAgent;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in KnowledgeAgents.
 */
public final class KnowledgeAgentsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final KnowledgeAgentsService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchServiceClientImpl client;

    /**
     * Initializes an instance of KnowledgeAgentsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    KnowledgeAgentsImpl(SearchServiceClientImpl client) {
        this.service
            = RestProxy.create(KnowledgeAgentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchServiceClientKnowledgeAgents to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClientKnowledgeAgents")
    public interface KnowledgeAgentsService {
        @Put("/agents('{agentName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeAgent>> createOrUpdate(@HostParam("endpoint") String endpoint,
            @PathParam("agentName") String agentName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") KnowledgeAgent knowledgeAgent,
            Context context);

        @Put("/agents('{agentName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeAgent> createOrUpdateSync(@HostParam("endpoint") String endpoint,
            @PathParam("agentName") String agentName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") KnowledgeAgent knowledgeAgent,
            Context context);

        @Delete("/agents('{agentName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> delete(@HostParam("endpoint") String endpoint, @PathParam("agentName") String agentName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/agents('{agentName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteSync(@HostParam("endpoint") String endpoint, @PathParam("agentName") String agentName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/agents('{agentName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeAgent>> get(@HostParam("endpoint") String endpoint,
            @PathParam("agentName") String agentName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/agents('{agentName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeAgent> getSync(@HostParam("endpoint") String endpoint,
            @PathParam("agentName") String agentName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/agents")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ListKnowledgeAgentsResult>> list(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/agents")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ListKnowledgeAgentsResult> listSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/agents")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeAgent>> create(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeAgent knowledgeAgent, Context context);

        @Post("/agents")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeAgent> createSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeAgent knowledgeAgent, Context context);
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createOrUpdateWithResponseAsync(String agentName,
        KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch,
            ifNoneMatch, requestOptions, context));
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createOrUpdateWithResponseAsync(String agentName,
        KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdate(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch,
            prefer, this.client.getApiVersion(), accept, knowledgeAgent, context);
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createOrUpdateAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions) {
        return createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createOrUpdateAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeAgent> createOrUpdateWithResponse(String agentName, KnowledgeAgent knowledgeAgent,
        String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdateSync(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch,
            ifNoneMatch, prefer, this.client.getApiVersion(), accept, knowledgeAgent, context);
    }

    /**
     * Creates a new agent or updates an agent if it already exists.
     * 
     * @param agentName The name of the agent to create or update.
     * @param knowledgeAgent The definition of the agent to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeAgent createOrUpdate(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions) {
        return createOrUpdateWithResponse(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions, Context.NONE)
            .getValue();
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String agentName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return FluxUtil
            .withContext(context -> deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions, context));
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String agentName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.delete(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        return deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String agentName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.deleteSync(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing agent.
     * 
     * @param agentName The name of the agent to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        deleteWithResponse(agentName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> getWithResponseAsync(String agentName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getWithResponseAsync(agentName, requestOptions, context));
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> getWithResponseAsync(String agentName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.get(this.client.getEndpoint(), agentName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> getAsync(String agentName, RequestOptions requestOptions) {
        return getWithResponseAsync(agentName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> getAsync(String agentName, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(agentName, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeAgent> getWithResponse(String agentName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getSync(this.client.getEndpoint(), agentName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an agent definition.
     * 
     * @param agentName The name of the agent to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeAgent get(String agentName, RequestOptions requestOptions) {
        return getWithResponse(agentName, requestOptions, Context.NONE).getValue();
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeAgent>> listSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), xMsClientRequestId,
                this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getKnowledgeAgents(), null, null));
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeAgent>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getKnowledgeAgents(), null, null));
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KnowledgeAgent> listAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions));
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KnowledgeAgent> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions, context));
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KnowledgeAgent> listSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeAgentsResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getKnowledgeAgents(), null, null);
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KnowledgeAgent> listSinglePage(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeAgentsResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getKnowledgeAgents(), null, null);
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> list(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions));
    }

    /**
     * Lists all agents available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions, context));
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createWithResponseAsync(KnowledgeAgent knowledgeAgent,
        RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createWithResponseAsync(knowledgeAgent, requestOptions, context));
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createWithResponseAsync(KnowledgeAgent knowledgeAgent,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            knowledgeAgent, context);
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions) {
        return createWithResponseAsync(knowledgeAgent, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions,
        Context context) {
        return createWithResponseAsync(knowledgeAgent, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeAgent> createWithResponse(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            knowledgeAgent, context);
    }

    /**
     * Creates a new agent.
     * 
     * @param knowledgeAgent The definition of the agent to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeAgent create(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions) {
        return createWithResponse(knowledgeAgent, requestOptions, Context.NONE).getValue();
    }
}
