// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListKnowledgeSourcesResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in KnowledgeSources.
 */
public final class KnowledgeSourcesImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final KnowledgeSourcesService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchServiceClientImpl client;

    /**
     * Initializes an instance of KnowledgeSourcesImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    KnowledgeSourcesImpl(SearchServiceClientImpl client) {
        this.service
            = RestProxy.create(KnowledgeSourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchServiceClientKnowledgeSources to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClientKnowledgeSources")
    public interface KnowledgeSourcesService {
        @Put("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeSource>> createOrUpdate(@HostParam("endpoint") String endpoint,
            @PathParam("sourceName") String sourceName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") KnowledgeSource knowledgeSource,
            Context context);

        @Put("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeSource> createOrUpdateSync(@HostParam("endpoint") String endpoint,
            @PathParam("sourceName") String sourceName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Prefer") String prefer, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") KnowledgeSource knowledgeSource,
            Context context);

        @Delete("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> delete(@HostParam("endpoint") String endpoint, @PathParam("sourceName") String sourceName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteSync(@HostParam("endpoint") String endpoint, @PathParam("sourceName") String sourceName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeSource>> get(@HostParam("endpoint") String endpoint,
            @PathParam("sourceName") String sourceName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/knowledgesources('{sourceName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeSource> getSync(@HostParam("endpoint") String endpoint,
            @PathParam("sourceName") String sourceName, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/knowledgesources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ListKnowledgeSourcesResult>> list(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/knowledgesources")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ListKnowledgeSourcesResult> listSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/knowledgesources")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeSource>> create(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeSource knowledgeSource, Context context);

        @Post("/knowledgesources")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeSource> createSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeSource knowledgeSource, Context context);
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createOrUpdateWithResponseAsync(String sourceName,
        KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch,
            ifNoneMatch, requestOptions, context));
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createOrUpdateWithResponseAsync(String sourceName,
        KnowledgeSource knowledgeSource, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdate(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch,
            prefer, this.client.getApiVersion(), accept, knowledgeSource, context);
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> createOrUpdateAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions) {
        return createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> createOrUpdateAsync(String sourceName, KnowledgeSource knowledgeSource, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return createOrUpdateWithResponseAsync(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions,
            context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeSource> createOrUpdateWithResponse(String sourceName, KnowledgeSource knowledgeSource,
        String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdateSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch,
            ifNoneMatch, prefer, this.client.getApiVersion(), accept, knowledgeSource, context);
    }

    /**
     * Creates a new knowledge source or updates an knowledge source if it already exists.
     * 
     * @param sourceName The name of the knowledge source to create or update.
     * @param knowledgeSource The definition of the knowledge source to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeSource createOrUpdate(String sourceName, KnowledgeSource knowledgeSource, String ifMatch,
        String ifNoneMatch, RequestOptions requestOptions) {
        return createOrUpdateWithResponse(sourceName, knowledgeSource, ifMatch, ifNoneMatch, requestOptions,
            Context.NONE).getValue();
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String sourceName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return FluxUtil
            .withContext(context -> deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions, context));
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String sourceName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.delete(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String sourceName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        return deleteWithResponseAsync(sourceName, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String sourceName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.deleteSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing knowledge source.
     * 
     * @param sourceName The name of the knowledge source to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String sourceName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        deleteWithResponse(sourceName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> getWithResponseAsync(String sourceName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getWithResponseAsync(sourceName, requestOptions, context));
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> getWithResponseAsync(String sourceName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.get(this.client.getEndpoint(), sourceName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> getAsync(String sourceName, RequestOptions requestOptions) {
        return getWithResponseAsync(sourceName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> getAsync(String sourceName, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(sourceName, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeSource> getWithResponse(String sourceName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getSync(this.client.getEndpoint(), sourceName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves a knowledge source definition.
     * 
     * @param sourceName The name of the knowledge source to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeSource get(String sourceName, RequestOptions requestOptions) {
        return getWithResponse(sourceName, requestOptions, Context.NONE).getValue();
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeSource>> listSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), xMsClientRequestId,
                this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getKnowledgeSources(), null, null));
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeSource>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getKnowledgeSources(), null, null));
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KnowledgeSource> listAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions));
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KnowledgeSource> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(requestOptions, context));
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KnowledgeSource> listSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeSourcesResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getKnowledgeSources(), null, null);
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<KnowledgeSource> listSinglePage(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeSourcesResult> res = service.listSync(this.client.getEndpoint(), xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getKnowledgeSources(), null, null);
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> list(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions));
    }

    /**
     * Lists all knowledge sources available for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable<>(() -> listSinglePage(requestOptions, context));
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createWithResponseAsync(KnowledgeSource knowledgeSource,
        RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createWithResponseAsync(knowledgeSource, requestOptions, context));
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeSource>> createWithResponseAsync(KnowledgeSource knowledgeSource,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            knowledgeSource, context);
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> createAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions) {
        return createWithResponseAsync(knowledgeSource, requestOptions)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeSource> createAsync(KnowledgeSource knowledgeSource, RequestOptions requestOptions,
        Context context) {
        return createWithResponseAsync(knowledgeSource, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeSource> createWithResponse(KnowledgeSource knowledgeSource, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            knowledgeSource, context);
    }

    /**
     * Creates a new knowledge source.
     * 
     * @param knowledgeSource The definition of the knowledge source to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a knowledge source definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeSource create(KnowledgeSource knowledgeSource, RequestOptions requestOptions) {
        return createWithResponse(knowledgeSource, requestOptions, Context.NONE).getValue();
    }
}
