// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListIndexStatsSummary;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.IndexStatisticsSummary;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the SearchServiceClient type.
 */
public final class SearchServiceClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final SearchServiceClientService service;

    /**
     * The endpoint URL of the search service.
     */
    private final String endpoint;

    /**
     * Gets The endpoint URL of the search service.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The KnowledgeAgentsImpl object to access its operations.
     */
    private final KnowledgeAgentsImpl knowledgeAgents;

    /**
     * Gets the KnowledgeAgentsImpl object to access its operations.
     * 
     * @return the KnowledgeAgentsImpl object.
     */
    public KnowledgeAgentsImpl getKnowledgeAgents() {
        return this.knowledgeAgents;
    }

    /**
     * The KnowledgeSourcesImpl object to access its operations.
     */
    private final KnowledgeSourcesImpl knowledgeSources;

    /**
     * Gets the KnowledgeSourcesImpl object to access its operations.
     * 
     * @return the KnowledgeSourcesImpl object.
     */
    public KnowledgeSourcesImpl getKnowledgeSources() {
        return this.knowledgeSources;
    }

    /**
     * The DataSourcesImpl object to access its operations.
     */
    private final DataSourcesImpl dataSources;

    /**
     * Gets the DataSourcesImpl object to access its operations.
     * 
     * @return the DataSourcesImpl object.
     */
    public DataSourcesImpl getDataSources() {
        return this.dataSources;
    }

    /**
     * The IndexersImpl object to access its operations.
     */
    private final IndexersImpl indexers;

    /**
     * Gets the IndexersImpl object to access its operations.
     * 
     * @return the IndexersImpl object.
     */
    public IndexersImpl getIndexers() {
        return this.indexers;
    }

    /**
     * The SkillsetsImpl object to access its operations.
     */
    private final SkillsetsImpl skillsets;

    /**
     * Gets the SkillsetsImpl object to access its operations.
     * 
     * @return the SkillsetsImpl object.
     */
    public SkillsetsImpl getSkillsets() {
        return this.skillsets;
    }

    /**
     * The SynonymMapsImpl object to access its operations.
     */
    private final SynonymMapsImpl synonymMaps;

    /**
     * Gets the SynonymMapsImpl object to access its operations.
     * 
     * @return the SynonymMapsImpl object.
     */
    public SynonymMapsImpl getSynonymMaps() {
        return this.synonymMaps;
    }

    /**
     * The IndexesImpl object to access its operations.
     */
    private final IndexesImpl indexes;

    /**
     * Gets the IndexesImpl object to access its operations.
     * 
     * @return the IndexesImpl object.
     */
    public IndexesImpl getIndexes() {
        return this.indexes;
    }

    /**
     * The AliasesImpl object to access its operations.
     */
    private final AliasesImpl aliases;

    /**
     * Gets the AliasesImpl object to access its operations.
     * 
     * @return the AliasesImpl object.
     */
    public AliasesImpl getAliases() {
        return this.aliases;
    }

    /**
     * Initializes an instance of SearchServiceClient client.
     * 
     * @param endpoint The endpoint URL of the search service.
     * @param apiVersion Api Version.
     */
    public SearchServiceClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    /**
     * Initializes an instance of SearchServiceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint The endpoint URL of the search service.
     * @param apiVersion Api Version.
     */
    public SearchServiceClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    /**
     * Initializes an instance of SearchServiceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint The endpoint URL of the search service.
     * @param apiVersion Api Version.
     */
    public SearchServiceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.knowledgeAgents = new KnowledgeAgentsImpl(this);
        this.knowledgeSources = new KnowledgeSourcesImpl(this);
        this.dataSources = new DataSourcesImpl(this);
        this.indexers = new IndexersImpl(this);
        this.skillsets = new SkillsetsImpl(this);
        this.synonymMaps = new SynonymMapsImpl(this);
        this.indexes = new IndexesImpl(this);
        this.aliases = new AliasesImpl(this);
        this.service
            = RestProxy.create(SearchServiceClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for SearchServiceClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClient")
    public interface SearchServiceClientService {
        @Get("/servicestats")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchServiceStatistics>> getServiceStatistics(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/servicestats")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchServiceStatistics> getServiceStatisticsSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexstats")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ListIndexStatsSummary>> getIndexStatsSummary(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexstats")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ListIndexStatsSummary> getIndexStatsSummarySync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchServiceStatistics>>
        getServiceStatisticsWithResponseAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getServiceStatisticsWithResponseAsync(requestOptions, context));
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchServiceStatistics>> getServiceStatisticsWithResponseAsync(RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getServiceStatistics(this.getEndpoint(), xMsClientRequestId, this.getApiVersion(), accept,
            context);
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceStatistics> getServiceStatisticsAsync(RequestOptions requestOptions) {
        return getServiceStatisticsWithResponseAsync(requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchServiceStatistics> getServiceStatisticsAsync(RequestOptions requestOptions, Context context) {
        return getServiceStatisticsWithResponseAsync(requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchServiceStatistics> getServiceStatisticsWithResponse(RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getServiceStatisticsSync(this.getEndpoint(), xMsClientRequestId, this.getApiVersion(), accept,
            context);
    }

    /**
     * Gets service level statistics for a search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service level statistics for a search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchServiceStatistics getServiceStatistics(RequestOptions requestOptions) {
        return getServiceStatisticsWithResponse(requestOptions, Context.NONE).getValue();
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IndexStatisticsSummary>>
        getIndexStatsSummarySinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil
            .withContext(context -> service.getIndexStatsSummary(this.getEndpoint(), xMsClientRequestId,
                this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getIndexesStatistics(), null, null));
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IndexStatisticsSummary>>
        getIndexStatsSummarySinglePageAsync(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service
            .getIndexStatsSummary(this.getEndpoint(), xMsClientRequestId, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getIndexesStatistics(), null, null));
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IndexStatisticsSummary> getIndexStatsSummaryAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> getIndexStatsSummarySinglePageAsync(requestOptions));
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IndexStatisticsSummary> getIndexStatsSummaryAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux<>(() -> getIndexStatsSummarySinglePageAsync(requestOptions, context));
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<IndexStatisticsSummary> getIndexStatsSummarySinglePage(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListIndexStatsSummary> res = service.getIndexStatsSummarySync(this.getEndpoint(), xMsClientRequestId,
            this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getIndexesStatistics(), null, null);
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<IndexStatisticsSummary> getIndexStatsSummarySinglePage(RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListIndexStatsSummary> res = service.getIndexStatsSummarySync(this.getEndpoint(), xMsClientRequestId,
            this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getIndexesStatistics(), null, null);
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IndexStatisticsSummary> getIndexStatsSummary(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> getIndexStatsSummarySinglePage(requestOptions));
    }

    /**
     * Retrieves a summary of statistics for all indexes in the search service.
     * 
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a request to retrieve stats summary of all indexes as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IndexStatisticsSummary> getIndexStatsSummary(RequestOptions requestOptions, Context context) {
        return new PagedIterable<>(() -> getIndexStatsSummarySinglePage(requestOptions, context));
    }
}
