// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchAlias;
import java.io.IOException;
import java.util.List;

/**
 * Response from a List Aliases request. If successful, it includes the associated index mappings for all aliases.
 */
@Immutable
public final class ListAliasesResult implements JsonSerializable<ListAliasesResult> {
    /*
     * The aliases in the Search service.
     */
    @Generated
    private final List<SearchAlias> aliases;

    /**
     * Creates an instance of ListAliasesResult class.
     * 
     * @param aliases the aliases value to set.
     */
    @Generated
    public ListAliasesResult(List<SearchAlias> aliases) {
        this.aliases = aliases;
    }

    /**
     * Get the aliases property: The aliases in the Search service.
     * 
     * @return the aliases value.
     */
    @Generated
    public List<SearchAlias> getAliases() {
        return this.aliases;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListAliasesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListAliasesResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListAliasesResult.
     */
    @Generated
    public static ListAliasesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean aliasesFound = false;
            List<SearchAlias> aliases = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    aliases = reader.readArray(reader1 -> SearchAlias.fromJson(reader1));
                    aliasesFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (aliasesFound) {
                return new ListAliasesResult(aliases);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
