// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.IndexStatisticsSummary;
import java.io.IOException;
import java.util.List;

/**
 * Response from a request to retrieve stats summary of all indexes. If successful, it includes the stats of each index
 * in the service.
 */
@Immutable
public final class ListIndexStatsSummary implements JsonSerializable<ListIndexStatsSummary> {
    /*
     * The Statistics summary of all indexes in the Search service.
     */
    @Generated
    private final List<IndexStatisticsSummary> indexesStatistics;

    /**
     * Creates an instance of ListIndexStatsSummary class.
     * 
     * @param indexesStatistics the indexesStatistics value to set.
     */
    @Generated
    public ListIndexStatsSummary(List<IndexStatisticsSummary> indexesStatistics) {
        this.indexesStatistics = indexesStatistics;
    }

    /**
     * Get the indexesStatistics property: The Statistics summary of all indexes in the Search service.
     * 
     * @return the indexesStatistics value.
     */
    @Generated
    public List<IndexStatisticsSummary> getIndexesStatistics() {
        return this.indexesStatistics;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListIndexStatsSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListIndexStatsSummary if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListIndexStatsSummary.
     */
    @Generated
    public static ListIndexStatsSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean indexesStatisticsFound = false;
            List<IndexStatisticsSummary> indexesStatistics = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    indexesStatistics = reader.readArray(reader1 -> IndexStatisticsSummary.fromJson(reader1));
                    indexesStatisticsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (indexesStatisticsFound) {
                return new ListIndexStatsSummary(indexesStatistics);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
