// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeAgent;
import java.io.IOException;
import java.util.List;

/**
 * The ListKnowledgeAgentsResult model.
 */
@Immutable
public final class ListKnowledgeAgentsResult implements JsonSerializable<ListKnowledgeAgentsResult> {
    /*
     * The value property.
     */
    @Generated
    private final List<KnowledgeAgent> knowledgeAgents;

    /**
     * Creates an instance of ListKnowledgeAgentsResult class.
     * 
     * @param knowledgeAgents the knowledgeAgents value to set.
     */
    @Generated
    public ListKnowledgeAgentsResult(List<KnowledgeAgent> knowledgeAgents) {
        this.knowledgeAgents = knowledgeAgents;
    }

    /**
     * Get the knowledgeAgents property: The value property.
     * 
     * @return the knowledgeAgents value.
     */
    @Generated
    public List<KnowledgeAgent> getKnowledgeAgents() {
        return this.knowledgeAgents;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.knowledgeAgents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListKnowledgeAgentsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListKnowledgeAgentsResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListKnowledgeAgentsResult.
     */
    @Generated
    public static ListKnowledgeAgentsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeAgentsFound = false;
            List<KnowledgeAgent> knowledgeAgents = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    knowledgeAgents = reader.readArray(reader1 -> KnowledgeAgent.fromJson(reader1));
                    knowledgeAgentsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeAgentsFound) {
                return new ListKnowledgeAgentsResult(knowledgeAgents);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
