// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerSkillset;
import java.io.IOException;
import java.util.List;

/**
 * Response from a list skillset request. If successful, it includes the full definitions of all skillsets.
 */
@Immutable
public final class ListSkillsetsResult implements JsonSerializable<ListSkillsetsResult> {
    /*
     * The skillsets defined in the Search service.
     */
    @Generated
    private final List<SearchIndexerSkillset> skillsets;

    /**
     * Creates an instance of ListSkillsetsResult class.
     * 
     * @param skillsets the skillsets value to set.
     */
    @Generated
    public ListSkillsetsResult(List<SearchIndexerSkillset> skillsets) {
        this.skillsets = skillsets;
    }

    /**
     * Get the skillsets property: The skillsets defined in the Search service.
     * 
     * @return the skillsets value.
     */
    @Generated
    public List<SearchIndexerSkillset> getSkillsets() {
        return this.skillsets;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListSkillsetsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListSkillsetsResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListSkillsetsResult.
     */
    @Generated
    public static ListSkillsetsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean skillsetsFound = false;
            List<SearchIndexerSkillset> skillsets = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    skillsets = reader.readArray(reader1 -> SearchIndexerSkillset.fromJson(reader1));
                    skillsetsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (skillsetsFound) {
                return new ListSkillsetsResult(skillsets);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
