// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The multi-region account of an Azure AI service resource that's attached to a skillset.
 */
@Fluent
public final class AIServicesAccountIdentity extends CognitiveServicesAccount {
    /*
     * A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";

    /*
     * The user-assigned managed identity used for connections to AI Service. If not specified, the system-assigned
     * managed identity is used. On updates to the skillset, if the identity is unspecified, the value remains
     * unchanged. If set to "none", the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /*
     * The subdomain url for the corresponding AI Service.
     */
    @Generated
    private final String subdomainUrl;

    /**
     * Creates an instance of AIServicesAccountIdentity class.
     * 
     * @param subdomainUrl the subdomainUrl value to set.
     */
    @Generated
    public AIServicesAccountIdentity(String subdomainUrl) {
        this.subdomainUrl = subdomainUrl;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of Azure AI service resource attached to a
     * skillset.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the identity property: The user-assigned managed identity used for connections to AI Service. If not
     * specified, the system-assigned managed identity is used. On updates to the skillset, if the identity is
     * unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
     * 
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The user-assigned managed identity used for connections to AI Service. If not
     * specified, the system-assigned managed identity is used. On updates to the skillset, if the identity is
     * unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
     * 
     * @param identity the identity value to set.
     * @return the AIServicesAccountIdentity object itself.
     */
    @Generated
    public AIServicesAccountIdentity setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the subdomainUrl property: The subdomain url for the corresponding AI Service.
     * 
     * @return the subdomainUrl value.
     */
    @Generated
    public String getSubdomainUrl() {
        return this.subdomainUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AIServicesAccountIdentity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("subdomainUrl", this.subdomainUrl);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AIServicesAccountIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AIServicesAccountIdentity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AIServicesAccountIdentity.
     */
    @Generated
    public static AIServicesAccountIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String description = null;
            boolean subdomainUrlFound = false;
            String subdomainUrl = null;
            String odataType = "#Microsoft.Azure.Search.AIServicesByIdentity";
            SearchIndexerDataIdentity identity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("subdomainUrl".equals(fieldName)) {
                    subdomainUrl = reader.getString();
                    subdomainUrlFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (subdomainUrlFound) {
                AIServicesAccountIdentity deserializedAIServicesAccountIdentity
                    = new AIServicesAccountIdentity(subdomainUrl);
                deserializedAIServicesAccountIdentity.setDescription(description);
                deserializedAIServicesAccountIdentity.odataType = odataType;
                deserializedAIServicesAccountIdentity.identity = identity;

                return deserializedAIServicesAccountIdentity;
            }
            throw new IllegalStateException("Missing required property: subdomainUrl");
        });
    }
}
