// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * The account key of an Azure AI service resource that's attached to a skillset, to be used with the resource's
 * subdomain.
 */
@Fluent
public final class AIServicesAccountKey extends CognitiveServicesAccount {
    /*
     * A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.AIServicesByKey";

    /*
     * The key used to provision the Azure AI service resource attached to a skillset.
     */
    @Generated
    private final String key;

    /*
     * The subdomain url for the corresponding AI Service.
     */
    @Generated
    private final String subdomainUrl;

    /**
     * Creates an instance of AIServicesAccountKey class.
     * 
     * @param key the key value to set.
     * @param subdomainUrl the subdomainUrl value to set.
     */
    @Generated
    public AIServicesAccountKey(String key, String subdomainUrl) {
        this.key = key;
        this.subdomainUrl = subdomainUrl;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of Azure AI service resource attached to a
     * skillset.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the key property: The key used to provision the Azure AI service resource attached to a skillset.
     * 
     * @return the key value.
     */
    @Generated
    public String getKey() {
        return this.key;
    }

    /**
     * Get the subdomainUrl property: The subdomain url for the corresponding AI Service.
     * 
     * @return the subdomainUrl value.
     */
    @Generated
    public String getSubdomainUrl() {
        return this.subdomainUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AIServicesAccountKey setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("subdomainUrl", this.subdomainUrl);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AIServicesAccountKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AIServicesAccountKey if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AIServicesAccountKey.
     */
    @Generated
    public static AIServicesAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String description = null;
            boolean keyFound = false;
            String key = null;
            boolean subdomainUrlFound = false;
            String subdomainUrl = null;
            String odataType = "#Microsoft.Azure.Search.AIServicesByKey";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                } else if ("subdomainUrl".equals(fieldName)) {
                    subdomainUrl = reader.getString();
                    subdomainUrlFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (keyFound && subdomainUrlFound) {
                AIServicesAccountKey deserializedAIServicesAccountKey = new AIServicesAccountKey(key, subdomainUrl);
                deserializedAIServicesAccountKey.setDescription(description);
                deserializedAIServicesAccountKey.odataType = odataType;

                return deserializedAIServicesAccountKey;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            if (!subdomainUrlFound) {
                missingProperties.add("subdomainUrl");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
