// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Specifies the AI Services Vision parameters for vectorizing a query image or text.
 */
@Fluent
public final class AIServicesVisionParameters implements JsonSerializable<AIServicesVisionParameters> {
    /*
     * The version of the model to use when calling the AI Services Vision service. It will default to the latest
     * available when not specified.
     */
    @Generated
    private final String modelVersion;

    /*
     * The resource URI of the AI Services resource.
     */
    @Generated
    private final String resourceUri;

    /*
     * API key of the designated AI Services resource.
     */
    @Generated
    private String apiKey;

    /*
     * The user-assigned managed identity used for outbound connections. If an authResourceId is provided and it's not
     * specified, the system-assigned managed identity is used. On updates to the index, if the identity is unspecified,
     * the value remains unchanged. If set to "none", the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity authIdentity;

    /**
     * Creates an instance of AIServicesVisionParameters class.
     * 
     * @param modelVersion the modelVersion value to set.
     * @param resourceUri the resourceUri value to set.
     */
    @Generated
    public AIServicesVisionParameters(String modelVersion, String resourceUri) {
        this.modelVersion = modelVersion;
        this.resourceUri = resourceUri;
    }

    /**
     * Get the modelVersion property: The version of the model to use when calling the AI Services Vision service. It
     * will default to the latest available when not specified.
     * 
     * @return the modelVersion value.
     */
    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Get the resourceUri property: The resource URI of the AI Services resource.
     * 
     * @return the resourceUri value.
     */
    @Generated
    public String getResourceUri() {
        return this.resourceUri;
    }

    /**
     * Get the apiKey property: API key of the designated AI Services resource.
     * 
     * @return the apiKey value.
     */
    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    /**
     * Set the apiKey property: API key of the designated AI Services resource.
     * 
     * @param apiKey the apiKey value to set.
     * @return the AIServicesVisionParameters object itself.
     */
    @Generated
    public AIServicesVisionParameters setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    /**
     * Get the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the index, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @return the authIdentity value.
     */
    @Generated
    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    /**
     * Set the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the index, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @param authIdentity the authIdentity value to set.
     * @return the AIServicesVisionParameters object itself.
     */
    @Generated
    public AIServicesVisionParameters setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeStringField("resourceUri", this.resourceUri);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("authIdentity", this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AIServicesVisionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AIServicesVisionParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AIServicesVisionParameters.
     */
    @Generated
    public static AIServicesVisionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean modelVersionFound = false;
            String modelVersion = null;
            boolean resourceUriFound = false;
            String resourceUri = null;
            String apiKey = null;
            SearchIndexerDataIdentity authIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    modelVersionFound = true;
                } else if ("resourceUri".equals(fieldName)) {
                    resourceUri = reader.getString();
                    resourceUriFound = true;
                } else if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                } else if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (modelVersionFound && resourceUriFound) {
                AIServicesVisionParameters deserializedAIServicesVisionParameters
                    = new AIServicesVisionParameters(modelVersion, resourceUri);
                deserializedAIServicesVisionParameters.apiKey = apiKey;
                deserializedAIServicesVisionParameters.authIdentity = authIdentity;

                return deserializedAIServicesVisionParameters;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!modelVersionFound) {
                missingProperties.add("modelVersion");
            }
            if (!resourceUriFound) {
                missingProperties.add("resourceUri");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
