// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Parameters for Azure Blob Storage knowledge source.
 */
@Fluent
public final class AzureBlobKnowledgeSourceParameters implements JsonSerializable<AzureBlobKnowledgeSourceParameters> {
    /*
     * An explicit identity to use for this knowledge source.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /*
     * Key-based connection string or the ResourceId format if using a managed identity.
     */
    @Generated
    private final String connectionString;

    /*
     * The name of the blob storage container.
     */
    @Generated
    private final String containerName;

    /*
     * Optional folder path within the container.
     */
    @Generated
    private String folderPath;

    /*
     * Optional vectorizer configuration for vectorizing content.
     */
    @Generated
    private VectorSearchVectorizer embeddingModel;

    /*
     * Optional chat completion model for image verbalization or context extraction.
     */
    @Generated
    private KnowledgeAgentModel chatCompletionModel;

    /*
     * Optional schedule for data ingestion.
     */
    @Generated
    private IndexingSchedule ingestionSchedule;

    /*
     * Resources created by the knowledge source.
     */
    @Generated
    private Map<String, String> createdResources;

    /*
     * Indicates whether image verbalization should be disabled.
     */
    @Generated
    private Boolean disableImageVerbalization;

    /**
     * Creates an instance of AzureBlobKnowledgeSourceParameters class.
     * 
     * @param connectionString the connectionString value to set.
     * @param containerName the containerName value to set.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters(String connectionString, String containerName) {
        this.connectionString = connectionString;
        this.containerName = containerName;
    }

    /**
     * Get the identity property: An explicit identity to use for this knowledge source.
     * 
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: An explicit identity to use for this knowledge source.
     * 
     * @param identity the identity value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the connectionString property: Key-based connection string or the ResourceId format if using a managed
     * identity.
     * 
     * @return the connectionString value.
     */
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    /**
     * Get the containerName property: The name of the blob storage container.
     * 
     * @return the containerName value.
     */
    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Get the folderPath property: Optional folder path within the container.
     * 
     * @return the folderPath value.
     */
    @Generated
    public String getFolderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: Optional folder path within the container.
     * 
     * @param folderPath the folderPath value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Get the embeddingModel property: Optional vectorizer configuration for vectorizing content.
     * 
     * @return the embeddingModel value.
     */
    @Generated
    public VectorSearchVectorizer getEmbeddingModel() {
        return this.embeddingModel;
    }

    /**
     * Set the embeddingModel property: Optional vectorizer configuration for vectorizing content.
     * 
     * @param embeddingModel the embeddingModel value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setEmbeddingModel(VectorSearchVectorizer embeddingModel) {
        this.embeddingModel = embeddingModel;
        return this;
    }

    /**
     * Get the chatCompletionModel property: Optional chat completion model for image verbalization or context
     * extraction.
     * 
     * @return the chatCompletionModel value.
     */
    @Generated
    public KnowledgeAgentModel getChatCompletionModel() {
        return this.chatCompletionModel;
    }

    /**
     * Set the chatCompletionModel property: Optional chat completion model for image verbalization or context
     * extraction.
     * 
     * @param chatCompletionModel the chatCompletionModel value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setChatCompletionModel(KnowledgeAgentModel chatCompletionModel) {
        this.chatCompletionModel = chatCompletionModel;
        return this;
    }

    /**
     * Get the ingestionSchedule property: Optional schedule for data ingestion.
     * 
     * @return the ingestionSchedule value.
     */
    @Generated
    public IndexingSchedule getIngestionSchedule() {
        return this.ingestionSchedule;
    }

    /**
     * Set the ingestionSchedule property: Optional schedule for data ingestion.
     * 
     * @param ingestionSchedule the ingestionSchedule value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setIngestionSchedule(IndexingSchedule ingestionSchedule) {
        this.ingestionSchedule = ingestionSchedule;
        return this;
    }

    /**
     * Get the createdResources property: Resources created by the knowledge source.
     * 
     * @return the createdResources value.
     */
    @Generated
    public Map<String, String> getCreatedResources() {
        return this.createdResources;
    }

    /**
     * Get the disableImageVerbalization property: Indicates whether image verbalization should be disabled.
     * 
     * @return the disableImageVerbalization value.
     */
    @Generated
    public Boolean isDisableImageVerbalization() {
        return this.disableImageVerbalization;
    }

    /**
     * Set the disableImageVerbalization property: Indicates whether image verbalization should be disabled.
     * 
     * @param disableImageVerbalization the disableImageVerbalization value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setDisableImageVerbalization(Boolean disableImageVerbalization) {
        this.disableImageVerbalization = disableImageVerbalization;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeJsonField("embeddingModel", this.embeddingModel);
        jsonWriter.writeJsonField("chatCompletionModel", this.chatCompletionModel);
        jsonWriter.writeJsonField("ingestionSchedule", this.ingestionSchedule);
        jsonWriter.writeBooleanField("disableImageVerbalization", this.disableImageVerbalization);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobKnowledgeSourceParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobKnowledgeSourceParameters.
     */
    @Generated
    public static AzureBlobKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean connectionStringFound = false;
            String connectionString = null;
            boolean containerNameFound = false;
            String containerName = null;
            SearchIndexerDataIdentity identity = null;
            String folderPath = null;
            VectorSearchVectorizer embeddingModel = null;
            KnowledgeAgentModel chatCompletionModel = null;
            IndexingSchedule ingestionSchedule = null;
            Map<String, String> createdResources = null;
            Boolean disableImageVerbalization = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    connectionString = reader.getString();
                    connectionStringFound = true;
                } else if ("containerName".equals(fieldName)) {
                    containerName = reader.getString();
                    containerNameFound = true;
                } else if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                } else if ("folderPath".equals(fieldName)) {
                    folderPath = reader.getString();
                } else if ("embeddingModel".equals(fieldName)) {
                    embeddingModel = VectorSearchVectorizer.fromJson(reader);
                } else if ("chatCompletionModel".equals(fieldName)) {
                    chatCompletionModel = KnowledgeAgentModel.fromJson(reader);
                } else if ("ingestionSchedule".equals(fieldName)) {
                    ingestionSchedule = IndexingSchedule.fromJson(reader);
                } else if ("createdResources".equals(fieldName)) {
                    createdResources = reader.readMap(reader1 -> reader1.getString());
                } else if ("disableImageVerbalization".equals(fieldName)) {
                    disableImageVerbalization = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (connectionStringFound && containerNameFound) {
                AzureBlobKnowledgeSourceParameters deserializedAzureBlobKnowledgeSourceParameters
                    = new AzureBlobKnowledgeSourceParameters(connectionString, containerName);
                deserializedAzureBlobKnowledgeSourceParameters.identity = identity;
                deserializedAzureBlobKnowledgeSourceParameters.folderPath = folderPath;
                deserializedAzureBlobKnowledgeSourceParameters.embeddingModel = embeddingModel;
                deserializedAzureBlobKnowledgeSourceParameters.chatCompletionModel = chatCompletionModel;
                deserializedAzureBlobKnowledgeSourceParameters.ingestionSchedule = ingestionSchedule;
                deserializedAzureBlobKnowledgeSourceParameters.createdResources = createdResources;
                deserializedAzureBlobKnowledgeSourceParameters.disableImageVerbalization = disableImageVerbalization;

                return deserializedAzureBlobKnowledgeSourceParameters;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!connectionStringFound) {
                missingProperties.add("connectionString");
            }
            if (!containerNameFound) {
                missingProperties.add("containerName");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
