// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The Azure Open AI model name that will be called.
 */
public final class AzureOpenAIModelName extends ExpandableStringEnum<AzureOpenAIModelName> {

    /**
     * Static value text-embedding-ada-002 for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName TEXT_EMBEDDING_ADA_002 = fromString("text-embedding-ada-002");

    /**
     * Static value text-embedding-3-large for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName TEXT_EMBEDDING_3_LARGE = fromString("text-embedding-3-large");

    /**
     * Static value text-embedding-3-small for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName TEXT_EMBEDDING_3_SMALL = fromString("text-embedding-3-small");

    /**
     * Static value gpt-4o for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName GPT4O = fromString("gpt-4o");

    /**
     * Static value gpt-4o-mini for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName GPT4OMINI = fromString("gpt-4o-mini");

    /**
     * Static value gpt-4.1 for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName GPT41 = fromString("gpt-4.1");

    /**
     * Static value gpt-4.1-mini for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName GPT41MINI = fromString("gpt-4.1-mini");

    /**
     * Static value gpt-4.1-nano for AzureOpenAIModelName.
     */
    @Generated
    public static final AzureOpenAIModelName GPT41NANO = fromString("gpt-4.1-nano");

    /**
     * Creates a new instance of AzureOpenAIModelName value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureOpenAIModelName() {
    }

    /**
     * Creates or finds a AzureOpenAIModelName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureOpenAIModelName.
     */
    @Generated
    public static AzureOpenAIModelName fromString(String name) {
        return fromString(name, AzureOpenAIModelName.class);
    }

    /**
     * Gets known AzureOpenAIModelName values.
     *
     * @return known AzureOpenAIModelName values.
     */
    @Generated
    public static Collection<AzureOpenAIModelName> values() {
        return values(AzureOpenAIModelName.class);
    }
}
